/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.manage;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.ArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.manage.helper.ManagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.model.MainStemEventData;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemArbitrateEvent
implements ArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(SystemArbitrateEvent.class);
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();

    public void init() {
        String rootPath = ManagePathUtils.getRoot();
        String channelRootPath = ManagePathUtils.getChannelRoot();
        String nodeRootPath = ManagePathUtils.getNodeRoot();
        try {
            this.zookeeper.create(rootPath, (Object)new byte[0], CreateMode.PERSISTENT);
            this.zookeeper.create(channelRootPath, (Object)new byte[0], CreateMode.PERSISTENT);
            this.zookeeper.create(nodeRootPath, (Object)new byte[0], CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("system_init", e);
        }
    }

    public void destory() {
        String rootPath = ManagePathUtils.getRoot();
        String channelRootPath = ManagePathUtils.getChannelRoot();
        String nodeRootPath = ManagePathUtils.getNodeRoot();
        try {
            this.zookeeper.deleteRecursive(channelRootPath);
            this.zookeeper.deleteRecursive(nodeRootPath);
            this.zookeeper.deleteRecursive(rootPath);
        }
        catch (ZkNoNodeException zkNoNodeException) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("system_destory", e);
        }
    }

    public void switchWarmup(Long channelId, Long pipelineId) {
        String path = ManagePathUtils.getMainStem(channelId, pipelineId);
        try {
            while (true) {
                Stat stat = new Stat();
                byte[] bytes = (byte[])this.zookeeper.readData(path, stat);
                MainStemEventData mainStemData = (MainStemEventData)JsonUtils.unmarshalFromByte((byte[])bytes, MainStemEventData.class);
                mainStemData.setActive(false);
                try {
                    this.zookeeper.writeData(path, (Object)JsonUtils.marshalToByte((Object)mainStemData), stat.getVersion());
                    logger.warn("relase channelId[{}],pipelineId[{}] mainstem successed! ", (Object)channelId, (Object)pipelineId);
                }
                catch (ZkBadVersionException zkBadVersionException) {
                    continue;
                }
                break;
            }
        }
        catch (ZkNoNodeException stat) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("releaseMainStem", pipelineId.toString(), e);
        }
    }
}

