/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.manage;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.ArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.manage.helper.ManagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.CreateMode;

public class PipelineArbitrateEvent
implements ArbitrateEvent {
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();

    public void init(Long channelId, Long pipelineId) {
        String path = ManagePathUtils.getPipeline(channelId, pipelineId);
        String processRootPath = ManagePathUtils.getProcessRoot(channelId, pipelineId);
        String terminRootPath = ManagePathUtils.getTerminRoot(channelId, pipelineId);
        String remedyRootPath = ManagePathUtils.getRemedyRoot(channelId, pipelineId);
        String lockRootPath = ManagePathUtils.getLockRoot(channelId, pipelineId);
        String loadLockPath = lockRootPath + "/" + "load";
        try {
            this.zookeeper.createPersistent(path, true);
            this.zookeeper.create(processRootPath, (Object)new byte[0], CreateMode.PERSISTENT);
            this.zookeeper.create(terminRootPath, (Object)new byte[0], CreateMode.PERSISTENT);
            this.zookeeper.create(remedyRootPath, (Object)new byte[0], CreateMode.PERSISTENT);
            this.zookeeper.create(lockRootPath, (Object)new byte[0], CreateMode.PERSISTENT);
            this.zookeeper.create(loadLockPath, (Object)new byte[0], CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("Pipeline_init", pipelineId.toString(), e);
        }
    }

    public void destory(Long channelId, Long pipelineId) {
        String path = ManagePathUtils.getPipeline(channelId, pipelineId);
        String processRootPath = ManagePathUtils.getProcessRoot(channelId, pipelineId);
        String terminRootPath = ManagePathUtils.getTerminRoot(channelId, pipelineId);
        String remedyRootPath = ManagePathUtils.getRemedyRoot(channelId, pipelineId);
        String lockRootPath = ManagePathUtils.getLockRoot(channelId, pipelineId);
        String loadLockPath = lockRootPath + "/" + "load";
        try {
            this.zookeeper.deleteRecursive(loadLockPath);
            this.zookeeper.deleteRecursive(lockRootPath);
            this.zookeeper.deleteRecursive(terminRootPath);
            this.zookeeper.deleteRecursive(remedyRootPath);
            this.zookeeper.deleteRecursive(processRootPath);
            this.zookeeper.deleteRecursive(path);
        }
        catch (ZkNoNodeException zkNoNodeException) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("Pipeline_destory", pipelineId.toString(), e);
        }
    }
}

