/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.interceptor;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInterceptor
implements MethodInterceptor {
    private static final String DATA_FORMAT = "yyyy-MM-dd HH:mm:ss.sss";
    private static String MESSAGE = "\n=======================================\n[Class:{0} , Method:{1} , time:{2} , take:{3}ms]\n{4}Result\r\t{5}\n=======================================";

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            result = methodInvocation.proceed();
        }
        catch (Exception e) {
            this.dump(methodInvocation, e, System.currentTimeMillis() - startTime);
            throw e;
        }
        this.dump(methodInvocation, result, System.currentTimeMillis() - startTime);
        return result;
    }

    protected Logger getLogger(Class obj) {
        return LoggerFactory.getLogger((Class)obj);
    }

    private void dump(MethodInvocation methodInvocation, Object result, long take) {
        Logger log = this.getLogger(methodInvocation.getMethod().getDeclaringClass());
        Object[] args = methodInvocation.getArguments();
        StringBuffer buffer = this.getArgsString(args);
        if (log.isInfoEnabled()) {
            String className = ClassUtils.getShortClassName(methodInvocation.getMethod().getDeclaringClass());
            String methodName = methodInvocation.getMethod().getName();
            String resultStr = this.getResultString(result);
            String now = new SimpleDateFormat(DATA_FORMAT).format(new Date());
            log.info(MessageFormat.format(MESSAGE, className, methodName, now, take, buffer.toString(), resultStr));
        }
    }

    protected String getResultString(Object result) {
        if (result == null) {
            return "";
        }
        if (result instanceof Map) {
            return this.getMapResultString((Map)result);
        }
        if (result instanceof List) {
            return this.getListResultString((List)result);
        }
        if (result.getClass().isArray()) {
            return this.getArrayResultString((Object[])result);
        }
        return ObjectUtils.toString((Object)result, (String)"").toString();
    }

    private String getMapResultString(Map result) {
        StringBuilder sb = new StringBuilder();
        Iterator i = result.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        sb.append('{');
        while (true) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append(key == this ? "(this Map)" : this.getResultString(key));
            sb.append('=');
            sb.append(value == this ? "(this Map)" : this.getResultString(value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    private String getListResultString(List result) {
        StringBuilder sb = new StringBuilder();
        Iterator i = result.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        sb.append('[');
        while (true) {
            Object e;
            sb.append((e = i.next()) == this ? "(this Collection)" : this.getResultString(e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    private String getArrayResultString(Object[] result) {
        return this.getListResultString(Arrays.asList(result));
    }

    private StringBuffer getArgsString(Object[] args) {
        StringBuffer buffer = new StringBuffer();
        String prefix = "args ";
        for (int i = 0; i < args.length; ++i) {
            if (args.length > 1) {
                buffer.append(prefix + (i + 1));
            }
            buffer.append("\r\t");
            buffer.append(this.getResultString(args[i]));
            buffer.append("\n");
        }
        return buffer;
    }
}

