/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.config;

import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigRegistry;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ArbitrateConfigUtils {
    public static Long getCurrentNid() {
        Node node = ArbitrateConfigRegistry.getConfig().currentNode();
        if (node != null) {
            return node.getId();
        }
        return null;
    }

    public static List<String> getServerAddrs() {
        Node node = ArbitrateConfigRegistry.getConfig().currentNode();
        if (node != null) {
            String addr = StringUtils.join((Collection)node.getParameters().getZkCluster().getServerList(), (char)',');
            return Arrays.asList(addr);
        }
        return new ArrayList<String>();
    }

    public static Pipeline getPipeline(Long pipelineId) {
        return ArbitrateConfigRegistry.getConfig().findPipeline(pipelineId);
    }

    public static Pipeline getOppositePipeline(Long pipelineId) {
        return ArbitrateConfigRegistry.getConfig().findOppositePipeline(pipelineId);
    }

    public static Channel getChannel(Long pipelineId) {
        return ArbitrateConfigRegistry.getConfig().findChannelByPipelineId(pipelineId);
    }

    public static Channel getChannelByChannelId(Long channelId) {
        return ArbitrateConfigRegistry.getConfig().findChannel(channelId);
    }

    public static int getParallelism(Long pipelineId) {
        return ArbitrateConfigRegistry.getConfig().findPipeline(pipelineId).getParameters().getParallelism().intValue();
    }

    public static Node findNode(Long nid) {
        return ArbitrateConfigRegistry.getConfig().findNode(nid);
    }
}

