/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.communication;

import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.communication.core.CommunicationClient;
import com.alibaba.otter.shared.communication.core.exception.CommunicationException;
import com.alibaba.otter.shared.communication.core.impl.DefaultCommunicationClientImpl;
import com.alibaba.otter.shared.communication.core.model.Callback;
import com.alibaba.otter.shared.communication.core.model.Event;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbitrateCommmunicationClient {
    private static final Logger logger = LoggerFactory.getLogger(ArbitrateCommmunicationClient.class);
    private CommunicationClient delegate;
    private List<String> managerAddress;
    private volatile int index = 0;

    public Object call(Long nid, Event event) {
        return this.delegate.call(this.convertToAddress(nid), event);
    }

    public void call(Long nid, Event event, Callback callback) {
        this.delegate.call(this.convertToAddress(nid), event, callback);
    }

    public Object callManager(Event event) {
        CommunicationException ex = null;
        for (int i = this.index; i < this.index + this.managerAddress.size(); ++i) {
            String address = this.managerAddress.get(i % this.managerAddress.size());
            try {
                Object result = this.delegate.call(address, event);
                this.index = i;
                return result;
            }
            catch (CommunicationException e) {
                ex = e;
                logger.warn("call manager [{}] event [{}] failed, maybe can try another manager.", (Object)address, (Object)event);
                continue;
            }
        }
        throw ex;
    }

    public void callManager(final Event event, final Callback callback) {
        if (this.delegate instanceof DefaultCommunicationClientImpl) {
            DefaultCommunicationClientImpl defaultClient = (DefaultCommunicationClientImpl)this.delegate;
            defaultClient.submit(new Runnable(){

                @Override
                public void run() {
                    Object result = ArbitrateCommmunicationClient.this.callManager(event);
                    callback.call(result);
                }
            });
        }
    }

    private String convertToAddress(Long nid) {
        Node node = ArbitrateConfigUtils.findNode(nid);
        if (node.getParameters().getUseExternalIp().booleanValue()) {
            return node.getParameters().getExternalIp() + ":" + node.getPort();
        }
        return node.getIp() + ":" + node.getPort();
    }

    public void setDelegate(CommunicationClient delegate) {
        this.delegate = delegate;
    }

    public void setManagerAddress(String managerAddress) {
        String server = StringUtils.replace((String)managerAddress, (String)";", (String)",");
        String[] servers = StringUtils.split((String)server, (char)',');
        this.managerAddress = Arrays.asList(servers);
        this.index = RandomUtils.nextInt((int)this.managerAddress.size());
    }
}

