/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl;

import com.alibaba.otter.shared.arbitrate.ArbitrateViewService;
import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.manage.helper.ManagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StageComparator;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.arbitrate.model.MainStemEventData;
import com.alibaba.otter.shared.arbitrate.model.PositionEventData;
import com.alibaba.otter.shared.arbitrate.model.ProcessNodeEventData;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import com.alibaba.otter.shared.common.model.statistics.stage.ProcessStat;
import com.alibaba.otter.shared.common.model.statistics.stage.StageStat;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import com.alibaba.otter.shared.common.utils.zookeeper.ZooKeeperx;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.springframework.util.CollectionUtils;

public class ArbitrateViewServiceImpl
implements ArbitrateViewService {
    private static final String CANAL_PATH = "/otter/canal/destinations/%s";
    private static final String CANAL_DATA_PATH = "/otter/canal/destinations/%s/%s";
    private static final String CANAL_CURSOR_PATH = "/otter/canal/destinations/%s/%s/cursor";
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();

    @Override
    public MainStemEventData mainstemData(Long channelId, Long pipelineId) {
        String path = ManagePathUtils.getMainStem(channelId, pipelineId);
        try {
            byte[] bytes = (byte[])this.zookeeper.readData(path);
            return (MainStemEventData)JsonUtils.unmarshalFromByte((byte[])bytes, MainStemEventData.class);
        }
        catch (ZkException e) {
            return null;
        }
    }

    @Override
    public Long getNextProcessId(Long channelId, Long pipelineId) {
        String processRoot = ManagePathUtils.getProcessRoot(channelId, pipelineId);
        IZkConnection connection = this.zookeeper.getConnection();
        ZooKeeper orginZk = ((ZooKeeperx)connection).getZookeeper();
        Stat processParentStat = new Stat();
        try {
            orginZk.getChildren(processRoot, false, processParentStat);
            return (long)(processParentStat.getCversion() + processParentStat.getNumChildren()) / 2L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public List<ProcessStat> listProcesses(Long channelId, Long pipelineId) {
        ArrayList<ProcessStat> processStats = new ArrayList<ProcessStat>();
        String processRoot = ManagePathUtils.getProcessRoot(channelId, pipelineId);
        IZkConnection connection = this.zookeeper.getConnection();
        ZooKeeper orginZk = ((ZooKeeperx)connection).getZookeeper();
        List processNodes = this.zookeeper.getChildren(processRoot);
        ArrayList<Long> processIds = new ArrayList<Long>();
        for (String processNode : processNodes) {
            processIds.add(ManagePathUtils.getProcessId(processNode));
        }
        Collections.sort(processIds);
        for (int i = 0; i < processIds.size(); ++i) {
            Long processId = (Long)processIds.get(i);
            ProcessStat processStat = new ProcessStat();
            processStat.setPipelineId(pipelineId);
            processStat.setProcessId(processId);
            ArrayList<StageStat> stageStats = new ArrayList<StageStat>();
            processStat.setStageStats(stageStats);
            try {
                String processPath = ManagePathUtils.getProcess(channelId, pipelineId, processId);
                Stat zkProcessStat = new Stat();
                List stages = orginZk.getChildren(processPath, false, zkProcessStat);
                Collections.sort(stages, new StageComparator());
                StageStat prev = null;
                for (String stage : stages) {
                    String stagePath = processPath + "/" + stage;
                    Stat zkStat = new Stat();
                    StageStat stageStat = new StageStat();
                    stageStat.setPipelineId(pipelineId);
                    stageStat.setProcessId(processId);
                    byte[] bytes = orginZk.getData(stagePath, false, zkStat);
                    if (bytes != null && bytes.length > 0) {
                        String json = StringUtils.remove((String)new String(bytes, "UTF-8"), (char)'@');
                        EtlEventData data = (EtlEventData)JsonUtils.unmarshalFromString((String)json, EtlEventData.class);
                        stageStat.setNumber(data.getNumber());
                        stageStat.setSize(data.getSize());
                        HashMap<String, Object> exts = new HashMap<String, Object>();
                        if (!CollectionUtils.isEmpty((Map)data.getExts())) {
                            exts.putAll(data.getExts());
                        }
                        exts.put("currNid", data.getCurrNid());
                        exts.put("nextNid", data.getNextNid());
                        exts.put("desc", data.getDesc());
                        stageStat.setExts(exts);
                    }
                    if (prev != null) {
                        stageStat.setStartTime(prev.getEndTime());
                    } else {
                        stageStat.setStartTime(Long.valueOf(zkProcessStat.getMtime()));
                    }
                    stageStat.setEndTime(Long.valueOf(zkStat.getMtime()));
                    if ("selected".equals(stage)) {
                        stageStat.setStage(StageType.SELECT);
                    } else if ("extracted".equals(stage)) {
                        stageStat.setStage(StageType.EXTRACT);
                    } else if ("transformed".equals(stage)) {
                        stageStat.setStage(StageType.TRANSFORM);
                    }
                    prev = stageStat;
                    stageStats.add(stageStat);
                }
                StageStat currentStageStat = new StageStat();
                currentStageStat.setPipelineId(pipelineId);
                currentStageStat.setProcessId(processId);
                if (prev == null) {
                    ProcessNodeEventData nodeData;
                    byte[] bytes = orginZk.getData(processPath, false, zkProcessStat);
                    if (bytes == null || bytes.length == 0 || (nodeData = (ProcessNodeEventData)JsonUtils.unmarshalFromByte((byte[])bytes, ProcessNodeEventData.class)).getStatus().isUnUsed()) continue;
                    currentStageStat.setStage(StageType.SELECT);
                    currentStageStat.setStartTime(Long.valueOf(zkProcessStat.getMtime()));
                } else {
                    String stage;
                    stage = prev.getStage();
                    if (stage.isSelect()) {
                        currentStageStat.setStage(StageType.EXTRACT);
                    } else if (stage.isExtract()) {
                        currentStageStat.setStage(StageType.TRANSFORM);
                    } else if (stage.isTransform()) {
                        currentStageStat.setStage(StageType.LOAD);
                    } else if (stage.isLoad()) continue;
                    currentStageStat.setStartTime(prev.getEndTime());
                }
                if (currentStageStat.getStage().isLoad()) {
                    if (i == 0) {
                        stageStats.add(currentStageStat);
                    }
                } else {
                    stageStats.add(currentStageStat);
                }
            }
            catch (KeeperException.NoNodeException processPath) {
            }
            catch (KeeperException e) {
                throw new ArbitrateException(e);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            processStats.add(processStat);
        }
        return processStats;
    }

    @Override
    public PositionEventData getCanalCursor(String destination, short clientId) {
        String path = String.format(CANAL_CURSOR_PATH, destination, String.valueOf(clientId));
        try {
            IZkConnection connection = this.zookeeper.getConnection();
            ZooKeeper orginZk = ((ZooKeeperx)connection).getZookeeper();
            Stat stat = new Stat();
            byte[] bytes = orginZk.getData(path, false, stat);
            PositionEventData eventData = new PositionEventData();
            eventData.setCreateTime(new Date(stat.getCtime()));
            eventData.setModifiedTime(new Date(stat.getMtime()));
            eventData.setPosition(new String(bytes, "UTF-8"));
            return eventData;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void removeCanalCursor(String destination, short clientId) {
        String path = String.format(CANAL_CURSOR_PATH, destination, String.valueOf(clientId));
        this.zookeeper.delete(path);
    }

    @Override
    public void removeCanal(String destination, short clientId) {
        String path = String.format(CANAL_DATA_PATH, destination, String.valueOf(clientId));
        this.zookeeper.deleteRecursive(path);
    }

    @Override
    public void removeCanal(String destination) {
        String path = String.format(CANAL_PATH, destination);
        this.zookeeper.deleteRecursive(path);
    }
}

