/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.select.selector.canal;

import com.alibaba.otter.node.etl.select.exceptions.SelectException;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CanalFilterSupport {
    public static String makeFilterExpression(Pipeline pipeline) {
        List dataMediaPairs = pipeline.getPairs();
        if (dataMediaPairs.isEmpty()) {
            throw new SelectException("ERROR ## the pair is empty,the pipeline id = " + pipeline.getId());
        }
        HashSet<String> mediaNames = new HashSet<String>();
        for (DataMediaPair dataMediaPair : dataMediaPairs) {
            DataMedia.ModeValue namespaceMode = dataMediaPair.getSource().getNamespaceMode();
            DataMedia.ModeValue nameMode = dataMediaPair.getSource().getNameMode();
            if (namespaceMode.getMode().isSingle()) {
                CanalFilterSupport.buildFilter(mediaNames, namespaceMode.getSingleValue(), nameMode, false);
                continue;
            }
            if (namespaceMode.getMode().isMulti()) {
                for (String namespace : namespaceMode.getMultiValue()) {
                    CanalFilterSupport.buildFilter(mediaNames, namespace, nameMode, false);
                }
                continue;
            }
            if (!namespaceMode.getMode().isWildCard()) continue;
            CanalFilterSupport.buildFilter(mediaNames, namespaceMode.getSingleValue(), nameMode, true);
        }
        StringBuilder result = new StringBuilder();
        Iterator iter = mediaNames.iterator();
        int i = -1;
        while (iter.hasNext()) {
            if (++i == 0) {
                result.append((String)iter.next());
                continue;
            }
            result.append(",").append((String)iter.next());
        }
        String markTable = pipeline.getParameters().getSystemSchema() + "." + pipeline.getParameters().getSystemMarkTable();
        String bufferTable = pipeline.getParameters().getSystemSchema() + "." + pipeline.getParameters().getSystemBufferTable();
        String dualTable = pipeline.getParameters().getSystemSchema() + "." + pipeline.getParameters().getSystemDualTable();
        if (!mediaNames.contains(markTable)) {
            result.append(",").append(markTable);
        }
        if (!mediaNames.contains(bufferTable)) {
            result.append(",").append(bufferTable);
        }
        if (!mediaNames.contains(dualTable)) {
            result.append(",").append(dualTable);
        }
        return result.toString();
    }

    private static void buildFilter(Set<String> mediaNames, String namespace, DataMedia.ModeValue nameMode, boolean wildcard) {
        String splitChar = ".";
        if (wildcard) {
            splitChar = "\\.";
        }
        if (nameMode.getMode().isSingle()) {
            mediaNames.add(namespace + splitChar + nameMode.getSingleValue());
        } else if (nameMode.getMode().isMulti()) {
            for (String name : nameMode.getMultiValue()) {
                mediaNames.add(namespace + splitChar + name);
            }
        } else if (nameMode.getMode().isWildCard()) {
            mediaNames.add(namespace + "\\." + nameMode.getSingleValue());
        }
    }
}

