/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.weight;

import com.alibaba.otter.node.etl.load.loader.weight.WeightBucket;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class WeightBuckets<T> {
    private List<WeightBucket<T>> buckets = new ArrayList<WeightBucket<T>>();

    public synchronized List<Long> weights() {
        return Lists.transform(this.buckets, (Function)new Function<WeightBucket<T>, Long>(){

            public Long apply(WeightBucket<T> input) {
                return input.getWeight();
            }
        });
    }

    public synchronized void addItem(long weight, T item) {
        WeightBucket<T> bucket = new WeightBucket<T>(weight);
        int index = this.indexedSearch(this.buckets, bucket);
        if (index > this.buckets.size() - 1) {
            bucket.addLastItem(item);
            this.buckets.add(index, bucket);
        } else if (this.buckets.get(index).getWeight() != weight) {
            bucket.addLastItem(item);
            this.buckets.add(index, bucket);
        } else {
            this.buckets.get(index).addLastItem(item);
        }
    }

    public synchronized List<T> getItems(long weight) {
        WeightBucket bucket = new WeightBucket(weight);
        int index = this.indexedSearch(this.buckets, bucket);
        if (index < this.buckets.size() && index >= 0) {
            return this.buckets.get(index).getBucket();
        }
        return new LinkedList();
    }

    private int indexedSearch(List<WeightBucket<T>> list, WeightBucket<T> item) {
        int i;
        for (i = 0; i < list.size(); ++i) {
            Comparable midVal = list.get(i);
            int cmp = midVal.compareTo(item);
            if (cmp == 0) {
                return i;
            }
            if (cmp > 0) {
                return i;
            }
            if (cmp >= 0) continue;
        }
        return i;
    }
}

