/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.weight;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class WeightBarrier {
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private volatile long threshold;

    public WeightBarrier() {
        this(Long.MAX_VALUE);
    }

    public WeightBarrier(long weight) {
        this.threshold = weight;
    }

    public void await(long weight) throws InterruptedException {
        try {
            this.lock.lockInterruptibly();
            while (!this.isPermit(weight)) {
                this.condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long weight, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            this.lock.lockInterruptibly();
            while (!this.isPermit(weight)) {
                this.condition.await(timeout, unit);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void single(long weight) throws InterruptedException {
        try {
            this.lock.lockInterruptibly();
            this.threshold = weight;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long state() {
        return this.threshold;
    }

    private boolean isPermit(long state) {
        return state <= this.state();
    }
}

