/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.interceptor;

import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.load.loader.LoadContext;
import com.alibaba.otter.node.etl.load.loader.interceptor.AbstractLoadInterceptor;
import com.alibaba.otter.node.etl.load.loader.interceptor.LoadInterceptor;
import com.alibaba.otter.shared.etl.model.ObjectData;
import java.util.ArrayList;
import java.util.List;

public class ChainLoadInterceptor
extends AbstractLoadInterceptor<LoadContext, ObjectData> {
    private List<LoadInterceptor> interceptors = new ArrayList<LoadInterceptor>();

    @Override
    public void prepare(LoadContext context) {
        if (this.interceptors == null) {
            return;
        }
        for (LoadInterceptor interceptor : this.interceptors) {
            interceptor.prepare(context);
        }
    }

    @Override
    public boolean before(LoadContext context, ObjectData currentData) {
        if (this.interceptors == null) {
            return false;
        }
        boolean result = false;
        for (LoadInterceptor interceptor : this.interceptors) {
            if (!(result |= interceptor.before(context, currentData))) continue;
            return result;
        }
        return result;
    }

    @Override
    public void transactionBegin(LoadContext context, List<ObjectData> currentDatas, DbDialect dialect) {
        if (this.interceptors == null) {
            return;
        }
        for (LoadInterceptor interceptor : this.interceptors) {
            interceptor.transactionBegin(context, currentDatas, dialect);
        }
    }

    @Override
    public void transactionEnd(LoadContext context, List<ObjectData> currentDatas, DbDialect dialect) {
        if (this.interceptors == null) {
            return;
        }
        for (LoadInterceptor interceptor : this.interceptors) {
            interceptor.transactionEnd(context, currentDatas, dialect);
        }
    }

    @Override
    public void after(LoadContext context, ObjectData currentData) {
        if (this.interceptors == null) {
            return;
        }
        for (LoadInterceptor interceptor : this.interceptors) {
            interceptor.after(context, currentData);
        }
    }

    @Override
    public void commit(LoadContext context) {
        if (this.interceptors == null) {
            return;
        }
        for (LoadInterceptor interceptor : this.interceptors) {
            interceptor.commit(context);
        }
    }

    @Override
    public void error(LoadContext context) {
        if (this.interceptors == null) {
            return;
        }
        for (LoadInterceptor interceptor : this.interceptors) {
            interceptor.error(context);
        }
    }

    public void setInterceptors(List<LoadInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

