/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db.interceptor.sql;

import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialectFactory;
import com.alibaba.otter.node.etl.common.db.dialect.SqlTemplate;
import com.alibaba.otter.node.etl.common.db.dialect.oracle.OracleSqlTemplate;
import com.alibaba.otter.node.etl.load.loader.db.context.DbLoadContext;
import com.alibaba.otter.node.etl.load.loader.interceptor.AbstractLoadInterceptor;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class SqlBuilderLoadInterceptor
extends AbstractLoadInterceptor<DbLoadContext, EventData> {
    private DbDialectFactory dbDialectFactory;

    @Override
    public boolean before(DbLoadContext context, EventData currentData) {
        DbDialect dbDialect = this.dbDialectFactory.getDbDialect(context.getIdentity().getPipelineId(), (DbMediaSource)context.getDataMediaSource());
        SqlTemplate sqlTemplate = dbDialect.getSqlTemplate();
        EventType type = currentData.getEventType();
        String sql = null;
        String schemaName = currentData.isWithoutSchema() ? null : currentData.getSchemaName();
        String shardColumns = null;
        if (dbDialect.isDRDS()) {
            shardColumns = dbDialect.getShardColumns(schemaName, currentData.getTableName());
        }
        if (type.isInsert()) {
            sql = CollectionUtils.isEmpty((Collection)currentData.getColumns()) && (dbDialect.isDRDS() || sqlTemplate instanceof OracleSqlTemplate) ? sqlTemplate.getInsertSql(schemaName, currentData.getTableName(), this.buildColumnNames(currentData.getKeys()), this.buildColumnNames(currentData.getColumns())) : sqlTemplate.getMergeSql(schemaName, currentData.getTableName(), this.buildColumnNames(currentData.getKeys()), this.buildColumnNames(currentData.getColumns()), new String[]{}, !dbDialect.isDRDS(), shardColumns);
        } else if (type.isUpdate()) {
            boolean existOldKeys = !CollectionUtils.isEmpty((Collection)currentData.getOldKeys());
            boolean rowMode = context.getPipeline().getParameters().getSyncMode().isRow();
            String[] keyColumns = null;
            String[] otherColumns = null;
            if (existOldKeys) {
                keyColumns = this.buildColumnNames(currentData.getOldKeys());
                otherColumns = dbDialect.isDRDS() ? this.buildColumnNames(currentData.getUpdatedColumns(), currentData.getUpdatedKeys()) : this.buildColumnNames(currentData.getUpdatedColumns(), currentData.getKeys());
            } else {
                keyColumns = this.buildColumnNames(currentData.getKeys());
                otherColumns = this.buildColumnNames(currentData.getUpdatedColumns());
            }
            sql = rowMode && !existOldKeys ? sqlTemplate.getMergeSql(schemaName, currentData.getTableName(), keyColumns, otherColumns, new String[]{}, !dbDialect.isDRDS(), shardColumns) : sqlTemplate.getUpdateSql(schemaName, currentData.getTableName(), keyColumns, otherColumns, !dbDialect.isDRDS(), shardColumns);
        } else if (type.isDelete()) {
            sql = sqlTemplate.getDeleteSql(schemaName, currentData.getTableName(), this.buildColumnNames(currentData.getKeys()));
        }
        if (currentData.getHint() != null) {
            currentData.setSql(currentData.getHint() + sql);
        } else {
            currentData.setSql(sql);
        }
        return false;
    }

    private String[] buildColumnNames(List<EventColumn> columns) {
        String[] result = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            EventColumn column = columns.get(i);
            result[i] = column.getColumnName();
        }
        return result;
    }

    private String[] buildColumnNames(List<EventColumn> columns1, List<EventColumn> columns2) {
        EventColumn column;
        String[] result = new String[columns1.size() + columns2.size()];
        int i = 0;
        for (i = 0; i < columns1.size(); ++i) {
            column = columns1.get(i);
            result[i] = column.getColumnName();
        }
        while (i < columns1.size() + columns2.size()) {
            column = columns2.get(i - columns1.size());
            result[i] = column.getColumnName();
            ++i;
        }
        return result;
    }

    public void setDbDialectFactory(DbDialectFactory dbDialectFactory) {
        this.dbDialectFactory = dbDialectFactory;
    }
}

