/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db.interceptor.operation;

import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialectFactory;
import com.alibaba.otter.node.etl.common.db.dialect.mysql.MysqlDialect;
import com.alibaba.otter.node.etl.common.db.dialect.oracle.OracleDialect;
import com.alibaba.otter.node.etl.load.loader.db.context.DbLoadContext;
import com.alibaba.otter.node.etl.load.loader.interceptor.AbstractLoadInterceptor;
import com.alibaba.otter.node.etl.load.loader.interceptor.LoadInterceptor;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.etl.model.EventData;
import java.util.List;

public class OperationInterceptorFactory
extends AbstractLoadInterceptor<DbLoadContext, EventData> {
    private DbDialectFactory dbDialectFactory;
    private LoadInterceptor[] mysqlInterceptors;
    private LoadInterceptor[] oracleInterceptors;
    private LoadInterceptor[] empty = new LoadInterceptor[0];

    @Override
    public void transactionBegin(DbLoadContext context, List<EventData> currentDatas, DbDialect dialect) {
        LoadInterceptor[] interceptors;
        for (LoadInterceptor interceptor : interceptors = this.getIntercetptor(context, currentDatas)) {
            interceptor.transactionBegin(context, currentDatas, dialect);
        }
    }

    @Override
    public void transactionEnd(DbLoadContext context, List<EventData> currentDatas, DbDialect dialect) {
        LoadInterceptor[] interceptors;
        for (LoadInterceptor interceptor : interceptors = this.getIntercetptor(context, currentDatas)) {
            interceptor.transactionEnd(context, currentDatas, dialect);
        }
    }

    private LoadInterceptor[] getIntercetptor(DbLoadContext context, List<EventData> currentData) {
        if (currentData == null || currentData.size() == 0) {
            return this.empty;
        }
        DataMedia dataMedia = ConfigHelper.findDataMedia((Pipeline)context.getPipeline(), (Long)currentData.get(0).getTableId());
        DbDialect dbDialect = this.dbDialectFactory.getDbDialect(context.getIdentity().getPipelineId(), (DbMediaSource)dataMedia.getSource());
        if (dbDialect instanceof MysqlDialect) {
            return this.mysqlInterceptors;
        }
        if (dbDialect instanceof OracleDialect) {
            return this.oracleInterceptors;
        }
        return this.empty;
    }

    public void setMysqlInterceptors(LoadInterceptor[] mysqlInterceptors) {
        this.mysqlInterceptors = mysqlInterceptors;
    }

    public void setOracleInterceptors(LoadInterceptor[] oracleInterceptors) {
        this.oracleInterceptors = oracleInterceptors;
    }

    public void setDbDialectFactory(DbDialectFactory dbDialectFactory) {
        this.dbDialectFactory = dbDialectFactory;
    }
}

