/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db.interceptor.log;

import com.alibaba.otter.node.etl.load.loader.db.DbLoadDumper;
import com.alibaba.otter.node.etl.load.loader.db.context.DbLoadContext;
import com.alibaba.otter.node.etl.load.loader.interceptor.AbstractLoadInterceptor;
import com.alibaba.otter.shared.etl.model.EventData;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogLoadInterceptor
extends AbstractLoadInterceptor<DbLoadContext, EventData> {
    private static final Logger logger = LoggerFactory.getLogger(LogLoadInterceptor.class);
    private static final String SEP = SystemUtils.LINE_SEPARATOR;
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private int batchSize = 50;
    private static String context_format = null;
    private boolean dump = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(DbLoadContext context) {
        boolean dumpThisEvent;
        boolean bl = dumpThisEvent = context.getPipeline().getParameters().isDumpEvent() != false || context.getPipeline().getParameters().isDryRun() != false;
        if (!this.dump || !dumpThisEvent || !logger.isInfoEnabled()) return;
        Class<LogLoadInterceptor> clazz = LogLoadInterceptor.class;
        synchronized (LogLoadInterceptor.class) {
            try {
                MDC.put((String)"load", (String)String.valueOf(context.getIdentity().getPipelineId()));
                logger.info(SEP + "****************************************************" + SEP);
                logger.info(this.dumpContextInfo("successed", context));
                logger.info("****************************************************" + SEP);
                logger.info("* process Data  *" + SEP);
                this.logEventDatas(context.getProcessedDatas());
                logger.info("-----------------" + SEP);
                logger.info("* failed Data *" + SEP);
                this.logEventDatas(context.getFailedDatas());
                logger.info("****************************************************" + SEP);
            }
            finally {
                MDC.remove((String)"load");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void error(DbLoadContext context) {
        boolean dumpThisEvent;
        boolean bl = dumpThisEvent = context.getPipeline().getParameters().isDumpEvent() != false || context.getPipeline().getParameters().isDryRun() != false;
        if (!this.dump || !dumpThisEvent || !logger.isInfoEnabled()) return;
        Class<LogLoadInterceptor> clazz = LogLoadInterceptor.class;
        synchronized (LogLoadInterceptor.class) {
            try {
                MDC.put((String)"load", (String)String.valueOf(context.getIdentity().getPipelineId()));
                logger.info(this.dumpContextInfo("error", context));
                logger.info("* process Data  *" + SEP);
                this.logEventDatas(context.getProcessedDatas());
                logger.info("-----------------" + SEP);
                logger.info("* failed Data *" + SEP);
                this.logEventDatas(context.getFailedDatas());
                logger.info("****************************************************" + SEP);
            }
            finally {
                MDC.remove((String)"load");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void logEventDatas(List<EventData> eventDatas) {
        int size = eventDatas.size();
        int index = 0;
        do {
            if (index + this.batchSize >= size) {
                logger.info(DbLoadDumper.dumpEventDatas(eventDatas.subList(index, size)));
                continue;
            }
            logger.info(DbLoadDumper.dumpEventDatas(eventDatas.subList(index, index + this.batchSize)));
        } while ((index += this.batchSize) < size);
    }

    private String dumpContextInfo(String status, DbLoadContext context) {
        int successed = context.getProcessedDatas().size();
        int failed = context.getFailedDatas().size();
        int all = context.getPrepareDatas().size();
        boolean isInterrupt = all != failed + successed;
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
        return MessageFormat.format(context_format, status, format.format(now), context.getIdentity().toString(), all, successed, failed, isInterrupt);
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    static {
        context_format = "* status : {0}  , time : {1} *" + SEP;
        context_format = context_format + "* Identity : {2} *" + SEP;
        context_format = context_format + "* total Data : [{3}] , success Data : [{4}] , failed Data : [{5}] , Interrupt : [{6}]" + SEP;
    }
}

