/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db;

import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import java.util.ArrayList;
import java.util.List;

public class DbLoadData {
    private List<TableLoadData> tables = new ArrayList<TableLoadData>();

    public DbLoadData() {
    }

    public DbLoadData(List<EventData> datas) {
        for (EventData data : datas) {
            this.merge(data);
        }
    }

    public void merge(EventData data) {
        TableLoadData tableData = this.findTableData(data.getTableId());
        EventType type = data.getEventType();
        if (type.isInsert()) {
            tableData.getInsertDatas().add(data);
        } else if (type.isUpdate()) {
            tableData.getUpadateDatas().add(data);
        } else if (type.isDelete()) {
            tableData.getDeleteDatas().add(data);
        }
    }

    public List<TableLoadData> getTables() {
        return this.tables;
    }

    private synchronized TableLoadData findTableData(Long tableId) {
        for (TableLoadData table : this.tables) {
            if (!table.getTableId().equals(tableId)) continue;
            return table;
        }
        TableLoadData data = new TableLoadData(tableId);
        this.tables.add(data);
        return data;
    }

    public static class TableLoadData {
        private Long tableId;
        private List<EventData> insertDatas = new ArrayList<EventData>();
        private List<EventData> upadateDatas = new ArrayList<EventData>();
        private List<EventData> deleteDatas = new ArrayList<EventData>();

        public TableLoadData(Long tableId) {
            this.tableId = tableId;
        }

        public List<EventData> getInsertDatas() {
            return this.insertDatas;
        }

        public void setInsertDatas(List<EventData> insertDatas) {
            this.insertDatas = insertDatas;
        }

        public List<EventData> getUpadateDatas() {
            return this.upadateDatas;
        }

        public void setUpadateDatas(List<EventData> upadateDatas) {
            this.upadateDatas = upadateDatas;
        }

        public List<EventData> getDeleteDatas() {
            return this.deleteDatas;
        }

        public void setDeleteDatas(List<EventData> deleteDatas) {
            this.deleteDatas = deleteDatas;
        }

        public Long getTableId() {
            return this.tableId;
        }

        public void setTableId(Long tableId) {
            this.tableId = tableId;
        }
    }
}

