/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.extract.extractor;

import com.alibaba.otter.node.etl.extract.exceptions.ExtractException;
import com.alibaba.otter.node.etl.extract.extractor.AbstractExtractor;
import com.alibaba.otter.shared.common.model.config.data.ColumnPair;
import com.alibaba.otter.shared.common.model.config.data.ColumnPairMode;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ViewExtractor
extends AbstractExtractor<DbBatch> {
    @Override
    public void extract(DbBatch dbBatch) throws ExtractException {
        Assert.notNull((Object)dbBatch);
        Assert.notNull((Object)dbBatch.getRowBatch());
        Pipeline pipeline = this.getPipeline(dbBatch.getRowBatch().getIdentity().getPipelineId());
        List dataMediaPairs = pipeline.getPairs();
        HashMap<Long, List> viewColumnPairs = new HashMap<Long, List>();
        HashMap<Long, ColumnPairMode> viewColumnPairModes = new HashMap<Long, ColumnPairMode>();
        for (DataMediaPair dataMediaPair : dataMediaPairs) {
            List columnPairs = dataMediaPair.getColumnPairs();
            viewColumnPairModes.put(dataMediaPair.getSource().getId(), dataMediaPair.getColumnPairMode());
            if (CollectionUtils.isEmpty((Collection)columnPairs)) continue;
            viewColumnPairs.put(dataMediaPair.getSource().getId(), columnPairs);
        }
        List eventDatas = dbBatch.getRowBatch().getDatas();
        HashSet<EventData> removeDatas = new HashSet<EventData>();
        for (EventData eventData : eventDatas) {
            List columns;
            if (eventData.getEventType().isDdl() || CollectionUtils.isEmpty((Collection)(columns = (List)viewColumnPairs.get(eventData.getTableId())))) continue;
            ColumnPairMode mode = (ColumnPairMode)viewColumnPairModes.get(eventData.getTableId());
            eventData.setColumns(this.columnFilter(eventData.getColumns(), columns, mode));
            eventData.setKeys(this.columnFilter(eventData.getKeys(), columns, mode));
            if (!CollectionUtils.isEmpty((Collection)eventData.getOldKeys())) {
                eventData.setOldKeys(this.columnFilter(eventData.getOldKeys(), columns, mode));
            }
            if (CollectionUtils.isEmpty((Collection)eventData.getKeys())) {
                throw new ExtractException(String.format("eventData after viewExtractor has no pks , pls check! identity:%s, new eventData:%s", dbBatch.getRowBatch().getIdentity().toString(), eventData.toString()));
            }
            if (!eventData.getEventType().isUpdate() || !CollectionUtils.isEmpty((Collection)eventData.getColumns()) && !CollectionUtils.isEmpty((Collection)eventData.getUpdatedColumns()) || !CollectionUtils.isEmpty((Collection)eventData.getOldKeys())) continue;
            removeDatas.add(eventData);
        }
        if (!CollectionUtils.isEmpty(removeDatas)) {
            eventDatas.removeAll(removeDatas);
        }
    }

    private List<EventColumn> columnFilter(List<EventColumn> eventColumns, List<ColumnPair> columnPairs, ColumnPairMode mode) {
        if (mode == null) {
            mode = ColumnPairMode.INCLUDE;
        }
        ArrayList<EventColumn> tempColumns = new ArrayList<EventColumn>();
        HashMap<String, ColumnPair> viewNames = new HashMap<String, ColumnPair>();
        for (ColumnPair columnPair : columnPairs) {
            viewNames.put(StringUtils.lowerCase((String)columnPair.getSourceColumn().getName()), columnPair);
        }
        for (EventColumn eventColumn : eventColumns) {
            if (mode.isInclude() && viewNames.containsKey(StringUtils.lowerCase((String)eventColumn.getColumnName()))) {
                tempColumns.add(eventColumn);
                continue;
            }
            if (!mode.isExclude() || viewNames.containsKey(StringUtils.lowerCase((String)eventColumn.getColumnName()))) continue;
            tempColumns.add(eventColumn);
        }
        return tempColumns;
    }
}

