/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.extract.extractor;

import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.extract.exceptions.ExtractException;
import com.alibaba.otter.node.etl.extract.extractor.AbstractExtractor;
import com.alibaba.otter.shared.common.model.config.ConfigException;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.channel.ChannelParameter;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class FreedomExtractor
extends AbstractExtractor<DbBatch> {
    private static final Logger logger = LoggerFactory.getLogger(FreedomExtractor.class);
    private static final char PK_SPLIT = '\u0001';
    private static final String TABLE_ID = "table_id";
    private static final String FULL_NAME = "full_name";
    private static final String TYPE = "type";
    private static final String PK_DATA = "pk_data";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void extract(DbBatch dbBatch) throws ExtractException {
        Assert.notNull((Object)dbBatch);
        Pipeline pipeline = this.getPipeline(dbBatch.getRowBatch().getIdentity().getPipelineId());
        boolean skipFreedom = pipeline.getParameters().getSkipFreedom();
        String bufferSchema = pipeline.getParameters().getSystemSchema();
        String bufferTable = pipeline.getParameters().getSystemBufferTable();
        List eventDatas = dbBatch.getRowBatch().getDatas();
        HashSet<EventData> removeDatas = new HashSet<EventData>();
        for (EventData eventData : eventDatas) {
            if (!StringUtils.equalsIgnoreCase((String)bufferSchema, (String)eventData.getSchemaName()) || !StringUtils.equalsIgnoreCase((String)bufferTable, (String)eventData.getTableName()) || eventData.getEventType().isDdl()) continue;
            if (skipFreedom) {
                removeDatas.add(eventData);
                continue;
            }
            if (eventData.getEventType().isInsert() || eventData.getEventType().isUpdate()) {
                EventColumn tableIdColumn = this.getMatchColumn(eventData.getColumns(), TABLE_ID);
                try {
                    DataMedia dataMedia = null;
                    Long tableId = Long.valueOf(tableIdColumn.getColumnValue());
                    eventData.setTableId(tableId.longValue());
                    if (tableId <= 0L) {
                        EventColumn fullNameColumn = this.getMatchColumn(eventData.getColumns(), FULL_NAME);
                        if (fullNameColumn != null) {
                            String[] names = StringUtils.split((String)fullNameColumn.getColumnValue(), (String)".");
                            if (names.length < 2) throw new ConfigException("no such DataMedia " + names);
                            dataMedia = ConfigHelper.findSourceDataMedia((Pipeline)pipeline, (String)names[0], (String)names[1]);
                            eventData.setTableId(dataMedia.getId().longValue());
                        }
                    } else {
                        dataMedia = ConfigHelper.findDataMedia((Pipeline)pipeline, (Long)Long.valueOf(tableIdColumn.getColumnValue()));
                    }
                    DbDialect dbDialect = this.dbDialectFactory.getDbDialect(pipeline.getId(), (DbMediaSource)dataMedia.getSource());
                    if (!dataMedia.getNameMode().getMode().isSingle() || !dataMedia.getNamespaceMode().getMode().isSingle()) {
                        String[] names;
                        boolean hasError = true;
                        EventColumn fullNameColumn = this.getMatchColumn(eventData.getColumns(), FULL_NAME);
                        if (fullNameColumn != null && (names = StringUtils.split((String)fullNameColumn.getColumnValue(), (String)".")).length >= 2) {
                            eventData.setSchemaName(names[0]);
                            eventData.setTableName(names[1]);
                            hasError = false;
                        }
                        if (hasError) {
                            logger.warn("dataMedia mode:{} , fullname:{} ", (Object)dataMedia.getMode(), (Object)(fullNameColumn == null ? null : fullNameColumn.getColumnValue()));
                            removeDatas.add(eventData);
                            continue;
                        }
                    } else {
                        eventData.setSchemaName(dataMedia.getNamespace());
                        eventData.setTableName(dataMedia.getName());
                    }
                    EventColumn typeColumn = this.getMatchColumn(eventData.getColumns(), TYPE);
                    EventType eventType = EventType.valuesOf((String)typeColumn.getColumnValue());
                    eventData.setEventType(eventType);
                    if (eventType.isUpdate()) {
                        eventData.setEventType(EventType.INSERT);
                    } else if (eventType.isDdl()) {
                        dbDialect.reloadTable(eventData.getSchemaName(), eventData.getTableName());
                        removeDatas.add(eventData);
                        continue;
                    }
                    EventColumn pkDataColumn = this.getMatchColumn(eventData.getColumns(), PK_DATA);
                    String pkData = pkDataColumn.getColumnValue();
                    String[] pks = StringUtils.split((String)pkData, (char)'\u0001');
                    Table table = dbDialect.findTable(eventData.getSchemaName(), eventData.getTableName());
                    ArrayList<EventColumn> newColumns = new ArrayList<EventColumn>();
                    Column[] primaryKeyColumns = table.getPrimaryKeyColumns();
                    if (primaryKeyColumns.length > pks.length) {
                        throw new ExtractException("data pk column size not match , data:" + eventData.toString());
                    }
                    Column[] allColumns = table.getColumns();
                    int pkIndex = 0;
                    for (int i = 0; i < allColumns.length; ++i) {
                        Column column = allColumns[i];
                        if (!column.isPrimaryKey()) continue;
                        EventColumn newColumn = new EventColumn();
                        newColumn.setIndex(i);
                        newColumn.setColumnName(column.getName());
                        newColumn.setColumnType(column.getTypeCode());
                        newColumn.setColumnValue(pks[pkIndex]);
                        newColumn.setKey(true);
                        newColumn.setNull(pks[pkIndex] == null);
                        newColumn.setUpdate(true);
                        newColumns.add(newColumn);
                        ++pkIndex;
                    }
                    eventData.setKeys(newColumns);
                    eventData.setOldKeys(new ArrayList());
                    eventData.setColumns(new ArrayList());
                    eventData.setSyncMode(ChannelParameter.SyncMode.ROW);
                    eventData.setSyncConsistency(ChannelParameter.SyncConsistency.MEDIA);
                    eventData.setRemedy(true);
                    eventData.setSize(1024L);
                }
                catch (ConfigException e) {
                    logger.info("find DataMedia error " + eventData.toString(), (Throwable)e);
                    removeDatas.add(eventData);
                }
                catch (Throwable e) {
                    logger.warn("process freedom data error " + eventData.toString(), e);
                    removeDatas.add(eventData);
                }
                continue;
            }
            removeDatas.add(eventData);
        }
        if (CollectionUtils.isEmpty(removeDatas)) return;
        eventDatas.removeAll(removeDatas);
    }

    private EventColumn getMatchColumn(List<EventColumn> columns, String columnName) {
        for (EventColumn column : columns) {
            if (!StringUtils.equalsIgnoreCase((String)column.getColumnName(), (String)columnName)) continue;
            return column;
        }
        return null;
    }
}

