/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.extract.extractor;

import com.alibaba.otter.node.etl.extract.exceptions.ExtractException;
import com.alibaba.otter.node.etl.extract.extractor.AbstractExtractor;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.utils.extension.ExtensionFactory;
import com.alibaba.otter.shared.common.utils.thread.ExecutorTemplate;
import com.alibaba.otter.shared.common.utils.thread.ExecutorTemplateGetter;
import com.alibaba.otter.shared.etl.extend.fileresolver.FileInfo;
import com.alibaba.otter.shared.etl.extend.fileresolver.FileResolver;
import com.alibaba.otter.shared.etl.extend.fileresolver.support.RemoteDirectoryFetcher;
import com.alibaba.otter.shared.etl.extend.fileresolver.support.RemoteDirectoryFetcherAware;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.FileData;
import com.alibaba.otter.shared.etl.model.Identity;
import com.alibaba.otter.shared.etl.model.RowBatch;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExtractor
extends AbstractExtractor<DbBatch> {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorTemplate.class);
    private ExtensionFactory extensionFactory;
    private RemoteDirectoryFetcher arandaRemoteDirectoryFetcher;
    private int retry = 3;
    private ExecutorTemplateGetter executorTemplateGetter;

    @Override
    public void extract(DbBatch dbBatch) throws ExtractException {
        List<FileData> fileDatas = this.doFileExtract(dbBatch.getRowBatch());
        FileBatch fileBatch = new FileBatch();
        fileBatch.setFiles(fileDatas);
        Identity identity = new Identity();
        identity.setChannelId(dbBatch.getRowBatch().getIdentity().getChannelId());
        identity.setPipelineId(dbBatch.getRowBatch().getIdentity().getPipelineId());
        identity.setProcessId(dbBatch.getRowBatch().getIdentity().getProcessId());
        fileBatch.setIdentity(identity);
        dbBatch.setFileBatch(fileBatch);
    }

    private List<FileData> doFileExtract(RowBatch rowBatch) {
        ArrayList<FileData> fileDatas = new ArrayList<FileData>();
        Pipeline pipeline = this.getPipeline(rowBatch.getIdentity().getPipelineId());
        List eventDatas = rowBatch.getDatas();
        for (EventData eventData : eventDatas) {
            if (eventData.getEventType().isDdl()) continue;
            List dataMediaPairs = ConfigHelper.findDataMediaPairByMediaId((Pipeline)pipeline, (Long)eventData.getTableId());
            if (dataMediaPairs == null) {
                throw new ExtractException("ERROR ## the dataMediaId = " + eventData.getTableId() + " dataMediaPair is null,please check");
            }
            for (DataMediaPair dataMediaPair : dataMediaPairs) {
                if (dataMediaPair.getResolverData() == null || dataMediaPair.getResolverData().getExtensionDataType() == null || dataMediaPair.getResolverData().getExtensionDataType().isClazz() && StringUtils.isBlank((String)dataMediaPair.getResolverData().getClazzPath()) || dataMediaPair.getResolverData().getExtensionDataType().isSource() && StringUtils.isBlank((String)dataMediaPair.getResolverData().getSourceText())) continue;
                FileResolver fileResolver = null;
                if (dataMediaPair.getResolverData() == null) continue;
                fileResolver = (FileResolver)this.extensionFactory.getExtension(FileResolver.class, dataMediaPair.getResolverData());
                if (fileResolver == null) {
                    throw new ExtractException("ERROR ## the dataMediaId = " + eventData.getTableId() + " the fileResolver className  = " + dataMediaPair.getResolverData().getClazzPath() + " is null ,please check the class");
                }
                if (fileResolver instanceof RemoteDirectoryFetcherAware) {
                    RemoteDirectoryFetcherAware remoteDirectoryFetcherAware = (RemoteDirectoryFetcherAware)fileResolver;
                    remoteDirectoryFetcherAware.setRemoteDirectoryFetcher(this.arandaRemoteDirectoryFetcher);
                }
                List<FileData> singleRowFileDatas = this.getSingleRowFileInfos(dataMediaPair.getId(), fileResolver, eventData);
                for (FileData data : singleRowFileDatas) {
                    if (fileDatas.contains(data)) continue;
                    fileDatas.add(data);
                }
            }
        }
        if (pipeline.getParameters().getFileDetect().booleanValue()) {
            this.doFileDetectCollector(pipeline, fileDatas);
        }
        return fileDatas;
    }

    private List<FileData> getSingleRowFileInfos(long pairId, FileResolver fileResolver, EventData eventData) {
        if (eventData.getEventType() == EventType.DELETE && !fileResolver.isDeleteRequired()) {
            return new ArrayList<FileData>();
        }
        HashMap<String, String> rowMap = new HashMap<String, String>();
        List keyColumns = eventData.getKeys();
        List eventColumns = eventData.getUpdatedColumns();
        for (EventColumn eventColumn : keyColumns) {
            rowMap.put(eventColumn.getColumnName().toUpperCase(), eventColumn.getColumnValue());
        }
        for (EventColumn eventColumn : eventColumns) {
            rowMap.put(eventColumn.getColumnName().toUpperCase(), eventColumn.getColumnValue());
        }
        FileInfo[] fileInfos = fileResolver.getFileInfo(rowMap);
        if (fileInfos == null || fileInfos.length == 0) {
            return new ArrayList<FileData>();
        }
        ArrayList<FileData> fileDatas = new ArrayList<FileData>();
        for (FileInfo fileInfo : fileInfos) {
            FileData fileData = new FileData();
            fileData.setPairId(pairId);
            fileData.setTableId(eventData.getTableId());
            fileData.setEventType(eventData.getEventType());
            fileData.setLastModifiedTime(fileInfo.getLastModifiedTime());
            fileData.setNameSpace(fileInfo.getNamespace());
            fileData.setPath(fileInfo.getPath());
            fileData.setSize(fileInfo.getSize());
            fileDatas.add(fileData);
        }
        return fileDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFileDetectCollector(Pipeline pipeline, List<FileData> fileDatas) {
        ExecutorTemplate executorTemplate = this.executorTemplateGetter.get();
        try {
            executorTemplate.start();
            executorTemplate.adjustPoolSize(pipeline.getParameters().getFileLoadPoolSize().intValue());
            for (final FileData fileData : fileDatas) {
                executorTemplate.submit(new Runnable(){

                    @Override
                    public void run() {
                        boolean isAranda = StringUtils.isNotEmpty((String)fileData.getNameSpace());
                        int count = 0;
                        Exception exception = null;
                        while (count++ < FileExtractor.this.retry) {
                            try {
                                if (isAranda) {
                                    throw new RuntimeException(fileData + " is not support!");
                                }
                                File file = new File(fileData.getPath());
                                fileData.setLastModifiedTime(file.lastModified());
                                fileData.setSize(file.length());
                                return;
                            }
                            catch (Exception e) {
                                fileData.setLastModifiedTime(Long.MIN_VALUE);
                                fileData.setSize(Long.MIN_VALUE);
                                exception = e;
                            }
                        }
                        if (count >= FileExtractor.this.retry) {
                            logger.warn(String.format("FileDetectCollector is error! collect failed[%s]", fileData.getNameSpace() + "/" + fileData.getPath()), (Throwable)exception);
                        }
                    }
                });
            }
            long start = System.currentTimeMillis();
            logger.info("start pipelinep[{}] waitFor FileData Size : {} ", (Object)pipeline.getId(), (Object)fileDatas.size());
            executorTemplate.waitForResult();
            logger.info("end pipelinep[{}] waitFor FileData cost : {} ms ", (Object)pipeline.getId(), (Object)(System.currentTimeMillis() - start));
        }
        finally {
            if (executorTemplate != null) {
                this.executorTemplateGetter.release(executorTemplate);
            }
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public void setArandaRemoteDirectoryFetcher(RemoteDirectoryFetcher arandaRemoteDirectoryFetcher) {
        this.arandaRemoteDirectoryFetcher = arandaRemoteDirectoryFetcher;
    }

    public void setExecutorTemplateGetter(ExecutorTemplateGetter executorTemplateGetter) {
        this.executorTemplateGetter = executorTemplateGetter;
    }
}

