/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.extract;

import com.alibaba.otter.node.etl.common.jmx.StageAggregation;
import com.alibaba.otter.node.etl.common.pipe.PipeKey;
import com.alibaba.otter.node.etl.common.task.GlobalTask;
import com.alibaba.otter.node.etl.conflict.FileBatchConflictDetectService;
import com.alibaba.otter.node.etl.extract.SetlFuture;
import com.alibaba.otter.node.etl.extract.extractor.OtterExtractorFactory;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.FileBatch;
import java.util.Collection;
import java.util.List;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

public class ExtractTask
extends GlobalTask {
    private OtterExtractorFactory otterExtractorFactory;
    private FileBatchConflictDetectService fileBatchConflictDetectService;

    public ExtractTask(Long pipelineId) {
        super(pipelineId);
    }

    @Override
    public void run() {
        MDC.put((String)"otter", (String)String.valueOf(this.pipelineId));
        while (this.running) {
            try {
                final EtlEventData etlEventData = this.arbitrateEventService.extractEvent().await(this.pipelineId);
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean profiling = ExtractTask.this.isProfiling();
                        Long profilingStartTime = null;
                        if (profiling) {
                            profilingStartTime = System.currentTimeMillis();
                        }
                        MDC.put((String)"otter", (String)String.valueOf(ExtractTask.this.pipelineId));
                        String currentName = Thread.currentThread().getName();
                        Thread.currentThread().setName(ExtractTask.this.createTaskName(ExtractTask.this.pipelineId, "ExtractWorker"));
                        try {
                            ExtractTask.this.pipeline = ExtractTask.this.configClientService.findPipeline(ExtractTask.this.pipelineId);
                            List keys = (List)etlEventData.getDesc();
                            long nextNodeId = etlEventData.getNextNid();
                            DbBatch dbBatch = ExtractTask.this.rowDataPipeDelegate.get(keys);
                            if (dbBatch == null) {
                                ExtractTask.this.processMissData(ExtractTask.this.pipelineId, "extract miss data with keys:" + keys.toString());
                                return;
                            }
                            ExtractTask.this.otterExtractorFactory.extract(dbBatch);
                            if (dbBatch.getFileBatch() != null && !CollectionUtils.isEmpty((Collection)dbBatch.getFileBatch().getFiles()) && ExtractTask.this.pipeline.getParameters().getFileDetect().booleanValue()) {
                                FileBatch fileBatch = ExtractTask.this.fileBatchConflictDetectService.detect(dbBatch.getFileBatch(), nextNodeId);
                                dbBatch.setFileBatch(fileBatch);
                            }
                            List<PipeKey> pipeKeys = ExtractTask.this.rowDataPipeDelegate.put(dbBatch, nextNodeId);
                            etlEventData.setDesc(pipeKeys);
                            if (profiling) {
                                Long profilingEndTime = System.currentTimeMillis();
                                ExtractTask.this.stageAggregationCollector.push(ExtractTask.this.pipelineId, StageType.EXTRACT, new StageAggregation.AggregationItem(profilingStartTime, profilingEndTime));
                            }
                            ExtractTask.this.arbitrateEventService.extractEvent().single(etlEventData);
                        }
                        catch (Throwable e) {
                            if (!ExtractTask.this.isInterrupt(e)) {
                                ExtractTask.this.logger.error(String.format("[%d] extractwork executor is error! data:%s", ExtractTask.this.pipelineId, etlEventData), e);
                                ExtractTask.this.sendRollbackTermin(ExtractTask.this.pipelineId, e);
                            } else {
                                ExtractTask.this.logger.info(String.format("[%d] extractwork executor is interrrupt! data:%s", ExtractTask.this.pipelineId, etlEventData), e);
                            }
                        }
                        finally {
                            Thread.currentThread().setName(currentName);
                            MDC.remove((String)"otter");
                        }
                    }
                };
                SetlFuture extractFuture = new SetlFuture(StageType.EXTRACT, etlEventData.getProcessId(), this.pendingFuture, task);
                this.executorService.execute(extractFuture);
            }
            catch (Throwable e) {
                if (this.isInterrupt(e)) {
                    this.logger.info(String.format("[%s] extractTask is interrupted!", this.pipelineId), e);
                    return;
                }
                this.logger.error(String.format("[%s] extractTask is error!", this.pipelineId), e);
                this.sendRollbackTermin((long)this.pipelineId, e);
            }
        }
    }

    public void setOtterExtractorFactory(OtterExtractorFactory otterExtractorFactory) {
        this.otterExtractorFactory = otterExtractorFactory;
    }

    public void setFileBatchConflictDetectService(FileBatchConflictDetectService fileBatchConflictDetectService) {
        this.fileBatchConflictDetectService = fileBatchConflictDetectService;
    }
}

