/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.rpc;

import com.alibaba.otter.node.common.communication.NodeCommmunicationClient;
import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.common.pipe.PipeDataType;
import com.alibaba.otter.node.etl.common.pipe.exception.PipeException;
import com.alibaba.otter.node.etl.common.pipe.impl.rpc.AbstractRpcPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.rpc.RpcPipeKey;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.core.model.EventType;
import com.alibaba.otter.shared.etl.model.DbBatch;

public class RowDataRpcPipe
extends AbstractRpcPipe<DbBatch, RpcPipeKey> {
    private ConfigClientService configClientService;
    private NodeCommmunicationClient nodeCommmunicationClient;

    public RowDataRpcPipe() {
        CommunicationRegistry.regist((EventType)RowDataRpc.get, (Object)this);
    }

    @Override
    public RpcPipeKey put(DbBatch data) throws PipeException {
        RpcPipeKey key = new RpcPipeKey();
        key.setIdentity(data.getRowBatch().getIdentity());
        key.setNid(this.getNid());
        key.setDataType(PipeDataType.DB_BATCH);
        this.cache.put(key, data);
        return key;
    }

    @Override
    public DbBatch get(RpcPipeKey key) throws PipeException {
        AbstractRpcPipe.RpcEvent event = new AbstractRpcPipe.RpcEvent(RowDataRpc.get);
        event.setKey(key);
        return (DbBatch)this.nodeCommmunicationClient.call(key.getNid(), (Event)event);
    }

    private DbBatch onGet(AbstractRpcPipe.RpcEvent event) {
        return (DbBatch)this.cache.remove(event.getKey());
    }

    private Long getNid() {
        return this.configClientService.currentNode().getId();
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setNodeCommmunicationClient(NodeCommmunicationClient nodeCommmunicationClient) {
        this.nodeCommmunicationClient = nodeCommmunicationClient;
    }

    public static enum RowDataRpc implements EventType
    {
        get;

    }
}

