/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.memory;

import com.alibaba.otter.node.etl.common.pipe.PipeDataType;
import com.alibaba.otter.node.etl.common.pipe.exception.PipeException;
import com.alibaba.otter.node.etl.common.pipe.impl.memory.AbstractMemoryPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.memory.MemoryPipeKey;
import com.alibaba.otter.node.etl.load.loader.db.FileloadDumper;
import com.alibaba.otter.shared.common.utils.NioUtils;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.FileData;
import com.alibaba.otter.shared.etl.model.Identity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RowDataMemoryPipe
extends AbstractMemoryPipe<DbBatch, MemoryPipeKey> {
    private static final Logger logger = LoggerFactory.getLogger(RowDataMemoryPipe.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss";
    private int retry = 3;
    private String downloadDir;

    @Override
    public MemoryPipeKey put(DbBatch data) {
        MemoryPipeKey key = new MemoryPipeKey();
        key.setIdentity(data.getRowBatch().getIdentity());
        key.setDataType(PipeDataType.DB_BATCH);
        this.cache.put(key, data);
        return key;
    }

    @Override
    public DbBatch get(MemoryPipeKey key) {
        return (DbBatch)this.cache.remove(key);
    }

    private File prepareFile(FileBatch fileBatch) {
        String dirname = this.buildFileName(fileBatch.getIdentity(), ClassUtils.getShortClassName(fileBatch.getClass()));
        File dir = new File(this.downloadDir, dirname);
        NioUtils.create((File)dir, (boolean)false, (int)3);
        List fileDatas = fileBatch.getFiles();
        for (FileData fileData : fileDatas) {
            String namespace = fileData.getNameSpace();
            String path = fileData.getPath();
            boolean isLocal = StringUtils.isBlank((String)namespace);
            String entryName = null;
            entryName = true == isLocal ? FilenameUtils.getPath((String)path) + FilenameUtils.getName((String)path) : namespace + File.separator + path;
            InputStream input = this.retrive(fileBatch.getIdentity(), fileData);
            if (input == null) continue;
            File entry = new File(dir, entryName);
            NioUtils.create((File)entry.getParentFile(), (boolean)false, (int)this.retry);
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(entry);
                NioUtils.copy((InputStream)input, (OutputStream)output);
            }
            catch (Exception e) {
                try {
                    throw new PipeException("prepareFile error for file[" + entry.getPath() + "]");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream retrive(Identity identity, FileData fileData) {
        boolean miss = false;
        try {
            if (StringUtils.isNotEmpty((String)fileData.getNameSpace())) {
                throw new RuntimeException(fileData + " is not support!");
            }
            try {
                File source = new File(fileData.getPath());
                if (source.exists() && source.isFile()) {
                    FileInputStream fileInputStream = new FileInputStream(source);
                    return fileInputStream;
                }
                miss = true;
                InputStream inputStream = null;
                return inputStream;
            }
            catch (FileNotFoundException ex) {
                miss = true;
                InputStream inputStream = null;
                return inputStream;
            }
        }
        finally {
            if (miss) {
                logger.error(FileloadDumper.dumpMissFileDatas(identity, fileData));
            }
        }
    }

    private String buildFileName(Identity identity, String prefix) {
        Date now = new Date();
        String time = new SimpleDateFormat(DATE_FORMAT).format(now);
        return MessageFormat.format("{0}-{1}-{2}-{3}-{4}", prefix, time, String.valueOf(identity.getChannelId()), String.valueOf(identity.getPipelineId()), String.valueOf(identity.getProcessId()));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.downloadDir);
        NioUtils.create((File)new File(this.downloadDir), (boolean)false, (int)3);
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }
}

