/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.http;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.common.pipe.impl.http.archive.ArchiveException;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RemoteUrlBuilder
implements InitializingBean {
    private int defaultDownloadPort = 8080;
    private ConfigClientService configClientService;
    private String urlFormat;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.configClientService);
        Assert.notNull((Object)this.urlFormat);
    }

    public String getUrl(Long pipelineId, String filePath) {
        Node node = this.configClientService.currentNode();
        Pipeline pipeline = this.configClientService.findPipeline(pipelineId);
        String ip = node.getIp();
        if ((node.getParameters().getUseExternalIp().booleanValue() || pipeline.getParameters().getUseExternalIp().booleanValue()) && StringUtils.isEmpty((String)(ip = node.getParameters().getExternalIp()))) {
            throw new ArchiveException(String.format("pipelineId:%s useExternalIp by nid[%s] has no external ip", String.valueOf(pipelineId), String.valueOf(node.getId())));
        }
        Integer port = node.getParameters().getDownloadPort();
        if (port == null || port < 0) {
            port = this.defaultDownloadPort;
        }
        return MessageFormat.format(this.urlFormat, ip, String.valueOf(port), filePath);
    }

    public void setDefaultDownloadPort(int defaultDownloadPort) {
        this.defaultDownloadPort = defaultDownloadPort;
    }

    public void setUrlFormat(String urlFormat) {
        this.urlFormat = urlFormat;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }
}

