/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.http;

import com.alibaba.otter.node.etl.common.io.EncryptedData;
import com.alibaba.otter.node.etl.common.io.download.DataRetriever;
import com.alibaba.otter.node.etl.common.pipe.PipeDataType;
import com.alibaba.otter.node.etl.common.pipe.exception.PipeException;
import com.alibaba.otter.node.etl.common.pipe.impl.http.AbstractHttpPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.http.HttpPipeKey;
import com.alibaba.otter.node.etl.common.pipe.impl.http.archive.ArchiveBean;
import com.alibaba.otter.node.etl.common.pipe.impl.http.archive.ArchiveRetriverCallback;
import com.alibaba.otter.node.etl.common.pipe.impl.http.archive.LazyFileInputStream;
import com.alibaba.otter.node.etl.load.loader.db.FileloadDumper;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.FileData;
import com.alibaba.otter.shared.etl.model.Identity;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class AttachmentHttpPipe
extends AbstractHttpPipe<Object, HttpPipeKey>
implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentHttpPipe.class);
    private BeanFactory beanFactory;
    private boolean encrypt = false;

    @Override
    public HttpPipeKey put(Object data) throws PipeException {
        if (data instanceof FileBatch) {
            return this.archiveFile((FileBatch)data);
        }
        throw new IllegalArgumentException("error argument");
    }

    @Override
    public File get(HttpPipeKey key) throws PipeException {
        return this.unpackFile(key);
    }

    private HttpPipeKey archiveFile(final FileBatch fileBatch) {
        String filename = this.buildFileName(fileBatch.getIdentity(), ClassUtils.getShortClassName(fileBatch.getClass()));
        File file = new File(this.htdocsDir, filename);
        List fileDatas = fileBatch.getFiles();
        Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(fileBatch.getIdentity().getPipelineId()));
        int poolSize = pipeline.getParameters().getFileLoadPoolSize();
        boolean useLocalFileMutliThread = pipeline.getParameters().getUseLocalFileMutliThread();
        ArchiveBean archiveBean = this.getArchiveBean();
        archiveBean.adjustPoolSize(poolSize);
        archiveBean.setUseLocalFileMutliThread(useLocalFileMutliThread);
        boolean done = archiveBean.pack(file, fileDatas, new ArchiveRetriverCallback<FileData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputStream retrive(FileData fileData) {
                boolean miss = false;
                try {
                    if (StringUtils.isNotEmpty((String)fileData.getNameSpace())) {
                        throw new RuntimeException(fileData + " is not support!");
                    }
                    File source = new File(fileData.getPath());
                    if (source.exists() && source.isFile()) {
                        LazyFileInputStream lazyFileInputStream = new LazyFileInputStream(source);
                        return lazyFileInputStream;
                    }
                    miss = true;
                    InputStream inputStream = null;
                    return inputStream;
                }
                finally {
                    if (miss && logger.isInfoEnabled()) {
                        MDC.put((String)"load", (String)String.valueOf(fileBatch.getIdentity().getPipelineId()));
                        logger.info(FileloadDumper.dumpMissFileDatas(fileBatch.getIdentity(), fileData));
                    }
                }
            }
        });
        if (!done) {
            return null;
        }
        HttpPipeKey key = new HttpPipeKey();
        key.setUrl(this.remoteUrlBuilder.getUrl(fileBatch.getIdentity().getPipelineId(), filename));
        key.setDataType(PipeDataType.FILE_BATCH);
        key.setIdentity(fileBatch.getIdentity());
        if (this.encrypt || pipeline.getParameters().getUseFileEncrypt().booleanValue()) {
            EncryptedData encryptedData = this.encryptFile(file);
            key.setKey(encryptedData.getKey());
            key.setCrc(encryptedData.getCrc());
        }
        return key;
    }

    private File unpackFile(HttpPipeKey key) {
        Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(key.getIdentity().getPipelineId()));
        DataRetriever dataRetriever = this.dataRetrieverFactory.createRetriever(pipeline.getParameters().getRetriever(), key.getUrl(), this.downloadDir);
        File archiveFile = null;
        try {
            dataRetriever.connect();
            dataRetriever.doRetrieve();
            archiveFile = dataRetriever.getDataAsFile();
        }
        catch (Exception e) {
            dataRetriever.abort();
            throw new PipeException("download_error", e);
        }
        finally {
            dataRetriever.disconnect();
        }
        if (StringUtils.isNotEmpty((String)key.getKey()) && StringUtils.isNotEmpty((String)key.getCrc())) {
            this.decodeFile(archiveFile, key.getKey(), key.getCrc());
        }
        String dir = StringUtils.removeEnd((String)archiveFile.getPath(), (String)(FilenameUtils.EXTENSION_SEPARATOR_STR + FilenameUtils.getExtension((String)archiveFile.getPath())));
        File unpackDir = new File(dir);
        this.getArchiveBean().unpack(archiveFile, unpackDir);
        return unpackDir;
    }

    private String buildFileName(Identity identity, String prefix) {
        Date now = new Date();
        String time = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(now);
        return MessageFormat.format("{0}-{1}-{2}-{3}-{4}.gzip", prefix, time, String.valueOf(identity.getChannelId()), String.valueOf(identity.getPipelineId()), String.valueOf(identity.getProcessId()));
    }

    private ArchiveBean getArchiveBean() {
        return (ArchiveBean)this.beanFactory.getBean("archiveBean", ArchiveBean.class);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }
}

