/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.http;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.common.io.EncryptUtils;
import com.alibaba.otter.node.etl.common.io.EncryptedData;
import com.alibaba.otter.node.etl.common.io.download.DataRetrieverFactory;
import com.alibaba.otter.node.etl.common.io.signature.ChecksumException;
import com.alibaba.otter.node.etl.common.jetty.JettyEmbedServer;
import com.alibaba.otter.node.etl.common.pipe.Pipe;
import com.alibaba.otter.node.etl.common.pipe.exception.PipeException;
import com.alibaba.otter.node.etl.common.pipe.impl.http.HttpPipeKey;
import com.alibaba.otter.node.etl.common.pipe.impl.http.RemoteUrlBuilder;
import com.alibaba.otter.shared.common.utils.ByteUtils;
import com.alibaba.otter.shared.common.utils.NioUtils;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractHttpPipe<T, KEY extends HttpPipeKey>
implements Pipe<T, KEY>,
InitializingBean {
    protected static final Long DEFAULT_PERIOD = 60000L;
    protected static final String UTF_8 = "UTF-8";
    protected static final String DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss";
    protected static ScheduledExecutorService schedulor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("HttpPipe-Cleaner"));
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected JettyEmbedServer jettyEmbedServer;
    protected Long period = DEFAULT_PERIOD;
    protected ConfigClientService configClientService;
    protected Long timeout = 86400000L;
    protected String htdocsDir;
    protected String downloadDir;
    protected RemoteUrlBuilder remoteUrlBuilder;
    protected DataRetrieverFactory dataRetrieverFactory;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.remoteUrlBuilder);
        Assert.notNull((Object)this.htdocsDir);
        NioUtils.create((File)new File(this.htdocsDir), (boolean)false, (int)3);
        if (StringUtils.isEmpty((String)this.downloadDir)) {
            this.downloadDir = this.htdocsDir;
        } else {
            NioUtils.create((File)new File(this.downloadDir), (boolean)false, (int)3);
        }
        schedulor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    long threshold = System.currentTimeMillis() - AbstractHttpPipe.this.timeout;
                    File htdocsDirFile = new File(AbstractHttpPipe.this.htdocsDir);
                    File[] htdocsFiles = htdocsDirFile.listFiles();
                    HashSet files = Sets.newHashSet();
                    for (File htdocsFile : htdocsFiles) {
                        files.add(htdocsFile);
                    }
                    if (!AbstractHttpPipe.this.downloadDir.equals(AbstractHttpPipe.this.htdocsDir)) {
                        File[] downloadFiles;
                        File downloadDirFile = new File(AbstractHttpPipe.this.downloadDir);
                        for (File downloadFile : downloadFiles = downloadDirFile.listFiles()) {
                            files.add(downloadFile);
                        }
                    }
                    for (File file : files) {
                        boolean isOld = FileUtils.isFileOlder((File)file, (long)threshold);
                        if (!isOld) continue;
                        NioUtils.delete((File)file, (int)3);
                    }
                }
                catch (Exception e) {
                    AbstractHttpPipe.this.logger.error("old_file_clean_error", (Throwable)e);
                }
            }
        }, DEFAULT_PERIOD, DEFAULT_PERIOD, TimeUnit.MILLISECONDS);
    }

    protected EncryptedData encryptFile(File file) {
        EncryptedData encryptedData = null;
        try {
            encryptedData = EncryptUtils.encrypt(file.getPath().getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            long origLength = file.length();
            int keyLength = ByteUtils.stringToBytes((String)encryptedData.getKey()).length;
            int crcLength = ByteUtils.stringToBytes((String)encryptedData.getCrc()).length;
            long totalLength = origLength + (long)crcLength + (long)keyLength;
            raf.setLength(totalLength);
            raf.seek(origLength);
            raf.write(ByteUtils.stringToBytes((String)encryptedData.getKey()), 0, keyLength);
            raf.seek(origLength + (long)keyLength);
            raf.write(ByteUtils.stringToBytes((String)encryptedData.getCrc()), 0, crcLength);
        }
        catch (Exception e) {
            try {
                throw new PipeException("write_encrypted_error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(raf);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)raf);
        return encryptedData;
    }

    protected void decodeFile(File file, String key, String crc) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            long totallength = file.length();
            int keyLength = ByteUtils.stringToBytes((String)key).length;
            int crcLength = ByteUtils.stringToBytes((String)crc).length;
            long pos = totallength - (long)keyLength - (long)crcLength;
            raf.seek(pos);
            byte[] keyBytes = new byte[keyLength];
            raf.read(keyBytes, 0, keyLength);
            String keystr = ByteUtils.bytesToString((byte[])keyBytes);
            if (!key.equals(keystr)) {
                throw new ChecksumException("unmatch garble key with[" + key + "],[" + keystr + "]");
            }
            raf.seek(pos + (long)keyLength);
            byte[] crcBytes = new byte[crcLength];
            raf.read(crcBytes, 0, crcLength);
            String crcStr = ByteUtils.bytesToString((byte[])crcBytes);
            if (!crc.equals(crcStr)) {
                throw new ChecksumException("unmatch crc with[" + crc + "],[" + crcStr + "]");
            }
            raf.setLength(pos);
        }
        catch (Exception e) {
            try {
                throw new PipeException("read_encrypted_error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(raf);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)raf);
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setJettyEmbedServer(JettyEmbedServer jettyEmbedServer) {
        this.jettyEmbedServer = jettyEmbedServer;
    }

    public void setRemoteUrlBuilder(RemoteUrlBuilder remoteUrlBuilder) {
        this.remoteUrlBuilder = remoteUrlBuilder;
    }

    public void setHtdocsDir(String htdocsDir) {
        this.htdocsDir = htdocsDir;
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    public void setDataRetrieverFactory(DataRetrieverFactory dataRetrieverFactory) {
        this.dataRetrieverFactory = dataRetrieverFactory;
    }
}

