/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.jmx;

import java.util.concurrent.atomic.AtomicLong;

public class StageAggregation {
    private static final String HISTOGRAM_FORMAT = "{total:%s,count:%s,maximum:%s,minimum:%s,average:%s,tps:%s,tpm:%s}";
    private static final Long ONE_SECOND = 1000L;
    private static final Long ONE_MINUTE = 60000L;
    private int bufferSize = 1024;
    private int indexMask;
    private AggregationItem[] table;
    private AtomicLong sequence = new AtomicLong(-1L);

    public StageAggregation(int bufferSize) {
        if (Integer.bitCount(bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.bufferSize = bufferSize;
        this.indexMask = this.bufferSize - 1;
        this.table = new AggregationItem[this.bufferSize];
    }

    public void push(AggregationItem aggregation) {
        long seq = this.sequence.incrementAndGet();
        this.table[this.getIndex((long)seq)] = aggregation;
    }

    public Long count() {
        return this.sequence.get();
    }

    public String histogram() {
        Long costs = 0L;
        Long items = 0L;
        Long max = 0L;
        Long min = Long.MAX_VALUE;
        Long tps = 0L;
        Long tpm = 0L;
        Long avg = 0L;
        Long lastTime = 0L;
        Long tpsCount = 0L;
        Long tpsTotal = 0L;
        Long tpsSecond = 0L;
        Long tpmCount = 0L;
        Long tpmTotal = 0L;
        Long tpmMinute = 0L;
        for (int i = 0; i < this.table.length; ++i) {
            AggregationItem aggregation = this.table[i];
            if (aggregation == null) continue;
            Long cost = aggregation.getEndTime() - aggregation.getStartTime();
            items = items + 1L;
            costs = costs + cost;
            if (cost > max) {
                max = cost;
            }
            if (cost < min) {
                min = cost;
            }
            if (lastTime != 0L) {
                Long l;
                Long l2;
                if (lastTime > aggregation.getEndTime() - ONE_SECOND) {
                    l2 = tpsCount;
                    l = tpsCount = Long.valueOf(tpsCount + 1L);
                } else {
                    tpsTotal = tpsTotal + tpsCount;
                    l2 = tpsSecond;
                    l = tpsSecond = Long.valueOf(tpsSecond + 1L);
                    tpsCount = 0L;
                }
                if (lastTime > aggregation.getEndTime() - ONE_MINUTE) {
                    l2 = tpmCount;
                    l = tpmCount = Long.valueOf(tpmCount + 1L);
                } else {
                    tpmTotal = tpmTotal + tpmCount;
                    l2 = tpmMinute;
                    l = tpmMinute = Long.valueOf(tpmMinute + 1L);
                    tpmCount = 0L;
                }
            }
            lastTime = aggregation.getEndTime();
        }
        tpsTotal = tpsTotal + tpsCount;
        Long l = tpsSecond;
        Long l3 = tpsSecond = Long.valueOf(tpsSecond + 1L);
        tpsCount = 0L;
        tpmTotal = tpmTotal + tpmCount;
        l = tpmMinute;
        l3 = tpmMinute = Long.valueOf(tpmMinute + 1L);
        tpmCount = 0L;
        if (items != 0L) {
            avg = costs / items;
        }
        if (tpsSecond != 0L) {
            tps = tpsTotal / tpsSecond;
        }
        if (tpmMinute != 0L) {
            tpm = tpmTotal / tpmMinute;
        }
        if (min == Long.MAX_VALUE) {
            min = 0L;
        }
        return String.format(HISTOGRAM_FORMAT, this.sequence.get() + 1L, items, max, min, avg, tps, tpm);
    }

    private int getIndex(long sequcnce) {
        return (int)sequcnce & this.indexMask;
    }

    public static class AggregationItem {
        private Long startTime;
        private Long endTime;
        private Long number;
        private Long size;

        public AggregationItem(Long startTime, Long endTime, Long number, Long size) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.number = number;
            this.size = size;
        }

        public AggregationItem(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public Long getNumber() {
            return this.number;
        }

        public void setNumber(Long number) {
            this.number = number;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }
    }
}

