/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.jmx;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.shared.common.model.config.node.Node;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.MessageFormat;
import javax.management.JMException;
import org.springframework.jmx.support.ConnectorServerFactoryBean;

public class JmxConnectorServerFactoryBean
extends ConnectorServerFactoryBean {
    private String SERVER_URL = "service:jmx:rmi://127.0.0.1:{0}/jndi/rmi://127.0.0.1:{0}/mbean";
    private boolean alwaysCreateRegistry = false;
    private ConfigClientService configClientService;

    public void afterPropertiesSet() throws JMException, IOException {
        Node node = this.configClientService.currentNode();
        int port = node.getPort().intValue() + 1;
        Integer mbeanPort = node.getParameters().getMbeanPort();
        if (mbeanPort != null && mbeanPort != 0) {
            port = mbeanPort;
        }
        String serviceUrl = MessageFormat.format(this.SERVER_URL, String.valueOf(port));
        super.setServiceUrl(serviceUrl);
        super.setObjectName((Object)"connector:name=rmi");
        this.getRegistry(port);
        super.afterPropertiesSet();
    }

    private Registry getRegistry(int registryPort) throws RemoteException {
        if (this.alwaysCreateRegistry) {
            this.logger.info((Object)"Creating new RMI registry");
            return LocateRegistry.createRegistry(registryPort);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Looking for RMI registry at port '" + registryPort + "'"));
        }
        try {
            Registry reg = LocateRegistry.getRegistry(registryPort);
            this.testRegistry(reg);
            return reg;
        }
        catch (RemoteException ex) {
            this.logger.debug((Object)"RMI registry access threw exception", (Throwable)ex);
            this.logger.info((Object)"Could not detect RMI registry - creating new one");
            return LocateRegistry.createRegistry(registryPort);
        }
    }

    private void testRegistry(Registry registry) throws RemoteException {
        registry.list();
    }

    public void setServiceUrl(String serviceUrl) {
        throw new UnsupportedOperationException("set serviceUrl is not support!");
    }

    public void setAlwaysCreateRegistry(boolean alwaysCreateRegistry) {
        this.alwaysCreateRegistry = alwaysCreateRegistry;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }
}

