/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.jetty;

import com.alibaba.otter.node.common.config.ConfigClientService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JettyEmbedServer
implements InitializingBean,
DisposableBean {
    private static final String DEFAULT_CONFIG = "jetty/jetty.xml";
    private static final Logger logger = LoggerFactory.getLogger(JettyEmbedServer.class);
    private Server server;
    private String config = "jetty/jetty.xml";
    private String htdocsDir;
    private ConfigClientService configClientService;

    public void afterPropertiesSet() throws Exception {
        Handler handler;
        Resource configXml = Resource.newSystemResource((String)this.config);
        XmlConfiguration configuration = new XmlConfiguration(configXml.getInputStream());
        this.server = (Server)configuration.configure();
        Integer port = this.getPort();
        if (port != null && port > 0) {
            Connector[] connectors;
            for (Connector connector : connectors = this.server.getConnectors()) {
                connector.setPort(port.intValue());
            }
        }
        if ((handler = this.server.getHandler()) != null && handler instanceof ServletContextHandler) {
            ServletContextHandler servletHandler = (ServletContextHandler)handler;
            servletHandler.getInitParams().put("org.eclipse.jetty.servlet.Default.resourceBase", this.htdocsDir);
        }
        this.server.start();
        if (logger.isInfoEnabled()) {
            logger.info("##Jetty Embed Server is startup!");
        }
    }

    private Integer getPort() {
        return this.configClientService.currentNode().getParameters().getDownloadPort();
    }

    public void destroy() throws Exception {
        this.server.stop();
        if (logger.isInfoEnabled()) {
            logger.info("##Jetty Embed Server is stop!");
        }
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setHtdocsDir(String htdocsDir) {
        this.htdocsDir = htdocsDir;
    }
}

