/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.download.impl.aria2c;

import com.alibaba.otter.node.etl.common.io.download.Download;
import com.alibaba.otter.node.etl.common.io.download.impl.AbstractCommandDownload;
import com.alibaba.otter.node.etl.common.io.download.impl.aria2c.Aria2cConfig;
import com.alibaba.otter.node.etl.common.io.download.impl.aria2c.Aria2cStat;
import com.alibaba.otter.shared.common.utils.cmd.Exec;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class Aria2cDownload
extends AbstractCommandDownload
implements Aria2cConfig,
Download {
    public Aria2cDownload(String cmdPath, String url, String dir) {
        super(cmdPath, url, dir, null);
    }

    public Aria2cDownload(String cmdPath, String url, String dir, String[] params) {
        super(cmdPath, url, dir, params);
    }

    @Override
    protected void buildCmd(String cmdPath, String[] params) {
        boolean retry = this.targetFile.exists();
        this.cmd = String.format("%s %s-o %s -d %s -l %s/aria2c.log %s %s", cmdPath, retry ? "-c " : "", this.targetFile.getName(), this.targetDir, this.targetDir, StringUtils.join((Object[])(params == null || params.length == 0 ? ARIA2C_PARAM : params), (char)' '), this.url);
    }

    @Override
    protected void analyzeResult(Exec.Result result) {
        int pos;
        String[] results = StringUtils.split((String)result.getStdout(), (String)SystemUtils.LINE_SEPARATOR);
        ArrayList<Aria2cStat> segmentStat = new ArrayList<Aria2cStat>();
        for (pos = 0; pos < results.length && !results[pos].toLowerCase().startsWith("gid|stat"); ++pos) {
        }
        ++pos;
        while (pos < results.length) {
            if (StringUtils.isNumeric((String)results[pos].substring(0, 1))) {
                String[] status = StringUtils.split((String)results[pos], (String)" \t|");
                if (status.length > 2) {
                    if (StringUtils.equalsIgnoreCase((String)Aria2cStat.OK.name(), (String)status[1])) {
                        segmentStat.add(Aria2cStat.OK);
                    } else if (StringUtils.equalsIgnoreCase((String)Aria2cStat.ERR.name(), (String)status[1])) {
                        segmentStat.add(Aria2cStat.ERR);
                    } else if (StringUtils.equalsIgnoreCase((String)Aria2cStat.INPR.name(), (String)status[1])) {
                        segmentStat.add(Aria2cStat.INPR);
                    }
                    this.logger.warn(results[pos]);
                } else {
                    this.logger.error("it seems aria2 changed it's status format: " + results[pos]);
                }
            }
            ++pos;
        }
        int size = segmentStat.size();
        int errCount = 0;
        int inprCount = 0;
        for (int i = 0; i < size; ++i) {
            Aria2cStat stat = (Aria2cStat)((Object)segmentStat.get(i));
            if (Aria2cStat.ERR == stat) {
                ++errCount;
                continue;
            }
            if (Aria2cStat.INPR != stat) continue;
            ++inprCount;
        }
        if (errCount == 0) {
            if (inprCount == 0) {
                this.completed.set(true);
            } else {
                this.paused.set(true);
            }
        } else if (errCount == size) {
            this.aborted.set(true);
        } else {
            this.paused.set(true);
        }
    }
}

