/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.download.impl;

import com.alibaba.otter.node.etl.common.io.download.Download;
import com.alibaba.otter.node.etl.common.io.download.DownloadStatus;
import com.alibaba.otter.node.etl.common.io.download.exception.DataRetrieveException;
import com.alibaba.otter.shared.common.utils.NioUtils;
import com.alibaba.otter.shared.common.utils.cmd.Exec;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandDownload
extends Observable
implements Download {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected AtomicBoolean aborted;
    protected String cmd;
    protected AtomicBoolean completed;
    protected AtomicBoolean paused;
    protected DownloadStatus status;
    protected String targetDir;
    protected File targetFile;
    protected String url;

    public AbstractCommandDownload(String cmdPath, String url, String dir, String[] params) {
        this.url = url;
        String fileName = url.substring(url.lastIndexOf("/") + 1).replace("%20", " ");
        this.targetDir = dir;
        this.targetFile = new File(this.targetDir, fileName);
        this.buildCmd(cmdPath, params);
        this.completed = new AtomicBoolean(false);
        this.aborted = new AtomicBoolean(false);
        this.paused = new AtomicBoolean(false);
        this.status = DownloadStatus.IDLE;
    }

    public void download() throws IOException {
        this.notifyStatusChange(DownloadStatus.CONNECTING);
        Exec.Result result = null;
        try {
            result = Exec.execute((String)this.cmd);
            if (!this.isSuccess(result.getExitCode())) {
                this.aborted.set(true);
                this.notifyException((Exception)((Object)new DataRetrieveException(result.toString())));
                this.notifyStatusChange(DownloadStatus.EXCEPTION);
            } else {
                this.analyzeResult(result);
                this.notifyMessage(result.toString());
                if (this.aborted.get()) {
                    this.notifyStatusChange(DownloadStatus.ABORT);
                } else if (this.paused.get()) {
                    this.notifyStatusChange(DownloadStatus.PAUSED);
                } else {
                    this.notifyStatusChange(DownloadStatus.COMPLETE);
                }
            }
        }
        catch (Exception ex) {
            this.aborted.set(true);
            this.notifyException((Exception)((Object)new DataRetrieveException(result != null ? ex.getMessage() + SystemUtils.LINE_SEPARATOR + result.toString() : ex.getMessage(), ex)));
        }
    }

    protected abstract void buildCmd(String var1, String[] var2);

    protected abstract void analyzeResult(Exec.Result var1);

    protected boolean isSuccess(int exitValue) {
        return exitValue == 0;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public boolean isAborted() {
        return this.aborted.get();
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public byte[] getAssociatedMemoryData() {
        if (this.targetFile.exists()) {
            try {
                return NioUtils.read((File)this.targetFile);
            }
            catch (IOException e) {
                throw new DataRetrieveException(e);
            }
        }
        return new byte[]{0};
    }

    @Override
    public long getContentLength() {
        if (this.targetFile.exists()) {
            return this.targetFile.length();
        }
        return 0L;
    }

    @Override
    public File getAssociatedLocalFile() {
        return this.targetFile;
    }

    protected void notifyMessage(String msg) {
        this.notifyEvent(msg);
    }

    protected void notifyStatusChange(DownloadStatus status) {
        this.status = status;
        this.notifyEvent((Object)status);
    }

    protected void notifyException(Exception ex) {
        this.notifyEvent(ex);
    }

    protected void notifyEvent(Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }
}

