/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.download;

import com.alibaba.otter.node.etl.common.io.download.DataRetriever;
import com.alibaba.otter.node.etl.common.io.download.exception.DataRetrieveException;
import com.alibaba.otter.node.etl.common.io.download.impl.aria2c.Aria2cRetriever;
import com.alibaba.otter.shared.common.model.config.parameter.SystemParameter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class DataRetrieverFactory {
    public DataRetriever createRetriever(SystemParameter.RetrieverType type, String url, String targetDir) {
        if (type.isAria2c()) {
            return this.getAria2cRetriever(type.getExe(), url, targetDir);
        }
        throw new DataRetrieveException("no DataRetriever for[" + type + "]");
    }

    private DataRetriever getAria2cRetriever(String cmd, String url, String targetDir) {
        if (StringUtils.isEmpty((String)cmd)) {
            cmd = SystemUtils.IS_OS_WINDOWS ? cmd + ".exe" : cmd;
        }
        return new Aria2cRetriever(cmd, url, targetDir);
    }
}

