/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.compress.impl.gzip;

import com.alibaba.otter.node.etl.common.io.compress.exception.CompressException;
import com.alibaba.otter.node.etl.common.io.compress.impl.AbstractCompressor;
import com.alibaba.otter.shared.common.utils.NioUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCompressor
extends AbstractCompressor {
    private static String DEFAULT_FILE_EXTENSION = "gzip";
    private static final String NAME = "gzip";
    private static final int GZIP_MAGIC = 35615;
    private static final byte[] HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public void compressTo(InputStream in, OutputStream out) throws CompressException {
        GZIPOutputStream gzipOut = null;
        try {
            gzipOut = new GZIPOutputStream(out);
            NioUtils.copy((InputStream)in, (OutputStream)gzipOut);
            gzipOut.finish();
        }
        catch (Exception e) {
            throw new CompressException("gzip_compress_error", e);
        }
    }

    @Override
    public void decompressTo(InputStream in, OutputStream out) throws CompressException {
        GZIPInputStream gzipin = null;
        try {
            gzipin = new GZIPInputStream(in);
            NioUtils.copy((InputStream)gzipin, (OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            throw new CompressException("gzip_decompress_error", e);
        }
    }

    @Override
    public byte[] getHeader() {
        return HEADER;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDefaultFileExtension() {
        return DEFAULT_FILE_EXTENSION;
    }
}

