/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.utils;

import com.alibaba.otter.node.etl.common.db.utils.ByteArrayConverter;
import com.alibaba.otter.node.etl.common.db.utils.SqlTimestampConverter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang.StringUtils;

public class SqlUtils {
    public static final String REQUIRED_FIELD_NULL_SUBSTITUTE = " ";
    public static final String SQLDATE_FORMAT = "yyyy-MM-dd";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Map<Integer, Class<?>> sqlTypeToJavaTypeMap = new HashMap();
    private static final ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();

    public static String sqlValueToString(ResultSet rs, int index, int sqlType) throws SQLException {
        Class<?> requiredType = sqlTypeToJavaTypeMap.get(sqlType);
        if (requiredType == null) {
            throw new IllegalArgumentException("unknow java.sql.Types - " + sqlType);
        }
        return SqlUtils.getResultSetValue(rs, index, requiredType);
    }

    public static Object stringToSqlValue(String value, int sqlType, boolean isRequired, boolean isEmptyStringNulled) {
        String sourceValue = value;
        if (SqlUtils.isTextType(sqlType)) {
            if (sourceValue == null || StringUtils.isEmpty((String)sourceValue) && isEmptyStringNulled) {
                return isRequired ? REQUIRED_FIELD_NULL_SUBSTITUTE : null;
            }
            return sourceValue;
        }
        if (StringUtils.isEmpty((String)sourceValue)) {
            return isEmptyStringNulled ? null : sourceValue;
        }
        Class<?> requiredType = sqlTypeToJavaTypeMap.get(sqlType);
        if (requiredType == null) {
            throw new IllegalArgumentException("unknow java.sql.Types - " + sqlType);
        }
        if (requiredType.equals(String.class)) {
            return sourceValue;
        }
        if (SqlUtils.isNumeric(sqlType)) {
            return convertUtilsBean.convert(sourceValue.trim(), requiredType);
        }
        return convertUtilsBean.convert(sourceValue, requiredType);
    }

    public static String encoding(String source, int sqlType, String sourceEncoding, String targetEncoding) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                if (StringUtils.isEmpty((String)source)) break;
                String fromEncoding = StringUtils.isBlank((String)sourceEncoding) ? "UTF-8" : sourceEncoding;
                String toEncoding = StringUtils.isBlank((String)targetEncoding) ? "UTF-8" : targetEncoding;
                try {
                    return new String(source.getBytes(fromEncoding), toEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }
        return source;
    }

    private static String getResultSetValue(ResultSet rs, int index, Class<?> requiredType) throws SQLException {
        if (requiredType == null) {
            return SqlUtils.getResultSetValue(rs, index);
        }
        Object value = null;
        boolean wasNullCheck = false;
        if (String.class.equals(requiredType)) {
            value = rs.getString(index);
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals(requiredType)) {
            value = rs.getBoolean(index);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals(requiredType)) {
            value = new Byte(rs.getByte(index));
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals(requiredType)) {
            value = new Short(rs.getShort(index));
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals(requiredType)) {
            value = new Long(rs.getLong(index));
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals(requiredType)) {
            value = rs.getBigDecimal(index);
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals(requiredType)) {
            value = new Float(rs.getFloat(index));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
            value = new Double(rs.getDouble(index));
            wasNullCheck = true;
        } else if (Time.class.equals(requiredType)) {
            value = rs.getString(index);
        } else if (Timestamp.class.equals(requiredType) || Date.class.equals(requiredType)) {
            value = rs.getString(index);
        } else if (BigDecimal.class.equals(requiredType)) {
            value = rs.getBigDecimal(index);
        } else if (BigInteger.class.equals(requiredType)) {
            value = rs.getBigDecimal(index);
        } else if (Blob.class.equals(requiredType)) {
            value = rs.getBlob(index);
        } else if (Clob.class.equals(requiredType)) {
            value = rs.getClob(index);
        } else if (byte[].class.equals(requiredType)) {
            try {
                byte[] bytes = rs.getBytes(index);
                if (bytes == null) {
                    value = null;
                }
                value = new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
        } else {
            value = SqlUtils.getResultSetValue(rs, index);
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return value == null ? null : convertUtilsBean.convert(value);
    }

    private static String getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        return obj == null ? null : convertUtilsBean.convert(obj);
    }

    public static boolean isNumeric(int sqlType) {
        return -7 == sqlType || -5 == sqlType || 3 == sqlType || 8 == sqlType || 6 == sqlType || 4 == sqlType || 2 == sqlType || 7 == sqlType || 5 == sqlType || -6 == sqlType;
    }

    public static boolean isTextType(int sqlType) {
        return sqlType == 1 || sqlType == 12 || sqlType == 2005 || sqlType == -1 || sqlType == -15 || sqlType == -9 || sqlType == 2011 || sqlType == -16;
    }

    static {
        convertUtilsBean.register(SqlTimestampConverter.SQL_TIMESTAMP, Date.class);
        convertUtilsBean.register(SqlTimestampConverter.SQL_TIMESTAMP, Time.class);
        convertUtilsBean.register(SqlTimestampConverter.SQL_TIMESTAMP, Timestamp.class);
        convertUtilsBean.register(ByteArrayConverter.SQL_BYTES, byte[].class);
        sqlTypeToJavaTypeMap.put(16, Boolean.class);
        sqlTypeToJavaTypeMap.put(-6, Integer.class);
        sqlTypeToJavaTypeMap.put(5, Integer.class);
        sqlTypeToJavaTypeMap.put(4, Integer.class);
        sqlTypeToJavaTypeMap.put(-5, Long.class);
        sqlTypeToJavaTypeMap.put(-7, BigInteger.class);
        sqlTypeToJavaTypeMap.put(7, Float.class);
        sqlTypeToJavaTypeMap.put(6, Float.class);
        sqlTypeToJavaTypeMap.put(8, Double.class);
        sqlTypeToJavaTypeMap.put(2, BigDecimal.class);
        sqlTypeToJavaTypeMap.put(3, BigDecimal.class);
        sqlTypeToJavaTypeMap.put(91, Date.class);
        sqlTypeToJavaTypeMap.put(92, Time.class);
        sqlTypeToJavaTypeMap.put(93, Timestamp.class);
        sqlTypeToJavaTypeMap.put(2004, byte[].class);
        sqlTypeToJavaTypeMap.put(2006, byte[].class);
        sqlTypeToJavaTypeMap.put(1111, byte[].class);
        sqlTypeToJavaTypeMap.put(2003, byte[].class);
        sqlTypeToJavaTypeMap.put(2002, byte[].class);
        sqlTypeToJavaTypeMap.put(2009, byte[].class);
        sqlTypeToJavaTypeMap.put(-2, byte[].class);
        sqlTypeToJavaTypeMap.put(70, byte[].class);
        sqlTypeToJavaTypeMap.put(2001, byte[].class);
        sqlTypeToJavaTypeMap.put(-3, byte[].class);
        sqlTypeToJavaTypeMap.put(2000, byte[].class);
        sqlTypeToJavaTypeMap.put(-4, byte[].class);
        sqlTypeToJavaTypeMap.put(1, String.class);
        sqlTypeToJavaTypeMap.put(12, String.class);
        sqlTypeToJavaTypeMap.put(-1, String.class);
        sqlTypeToJavaTypeMap.put(-16, String.class);
        sqlTypeToJavaTypeMap.put(-15, String.class);
        sqlTypeToJavaTypeMap.put(-9, String.class);
        sqlTypeToJavaTypeMap.put(2011, String.class);
        sqlTypeToJavaTypeMap.put(2005, String.class);
    }
}

