/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.utils;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Map;

public class DdlUtils {
    public static String convert(String sql, String sourceSchema, String sourceTable, String targetSchema, String targetTable) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement stmt = parser.parseStatement();
        StringBuilder out = new StringBuilder();
        OtterMyqlOutputVisitor visitor = new OtterMyqlOutputVisitor(out, sourceSchema, sourceTable, targetSchema, targetTable);
        stmt.accept((SQLASTVisitor)visitor);
        return out.toString();
    }

    public static class OtterMyqlOutputVisitor
    extends MySqlOutputVisitor {
        private String targetSchema;
        private String targetTable;
        private String sourceSchema;
        private String sourceTable;

        public OtterMyqlOutputVisitor(Appendable appender, String sourceSchema, String sourceTable, String targetSchema, String targetTable) {
            super(appender);
            this.sourceSchema = sourceSchema;
            this.sourceTable = sourceTable;
            this.targetSchema = targetSchema;
            this.targetTable = targetTable;
        }

        private void processTableName(SQLExpr sqlName) {
            if (sqlName instanceof SQLPropertyExpr) {
                SQLIdentifierExpr owner = (SQLIdentifierExpr)((SQLPropertyExpr)sqlName).getOwner();
                String oldSchem = this.unescapeName(owner.getName());
                String oldTable = this.unescapeName(((SQLPropertyExpr)sqlName).getName());
                if ((this.sourceSchema == null || oldSchem.equalsIgnoreCase(this.sourceSchema)) && (this.sourceTable == null || oldTable.equalsIgnoreCase(this.sourceTable))) {
                    owner.setName("`" + this.targetSchema + "`");
                    ((SQLPropertyExpr)sqlName).setName("`" + this.targetTable + "`");
                }
            } else if (sqlName instanceof SQLIdentifierExpr) {
                String oldTable = this.unescapeName(((SQLIdentifierExpr)sqlName).getName());
                if (this.sourceTable == null || oldTable.equalsIgnoreCase(this.sourceTable)) {
                    ((SQLIdentifierExpr)sqlName).setName("`" + this.targetTable + "`");
                }
            } else {
                throw new RuntimeException("not support SQLName:" + sqlName);
            }
            sqlName.accept((SQLASTVisitor)this);
        }

        private String unescapeName(String name) {
            if (name == null || name.length() <= 0) {
                return name;
            }
            if (name.charAt(0) != '`') {
                return name;
            }
            if (name.charAt(name.length() - 1) != '`') {
                throw new IllegalArgumentException("id start with a '`' must end with a '`', id: " + name);
            }
            StringBuilder sb = new StringBuilder(name.length() - 2);
            int endIndex = name.length() - 1;
            boolean hold = false;
            for (int i = 1; i < endIndex; ++i) {
                char c = name.charAt(i);
                if (c == '`' && !hold) {
                    hold = true;
                    continue;
                }
                hold = false;
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                sb.append(c);
            }
            return sb.toString();
        }

        public boolean visit(MySqlCreateTableStatement x) {
            int size;
            this.print0(this.ucase ? "CREATE " : "create ");
            for (SQLCommentHint hint : x.getHints()) {
                hint.accept((SQLASTVisitor)this);
                this.print(' ');
            }
            if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
                this.print0(this.ucase ? "TEMPORARY TABLE " : "temporary table ");
            } else {
                this.print0(this.ucase ? "TABLE " : "table ");
            }
            if (x.isIfNotExiists()) {
                this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
            }
            this.processTableName((SQLExpr)x.getName());
            if (x.getLike() != null) {
                this.print0(this.ucase ? " LIKE " : " like ");
                x.getLike().accept((SQLASTVisitor)this);
            }
            if ((size = x.getTableElementList().size()) > 0) {
                this.print0(" (");
                this.incrementIndent();
                this.println();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print0(", ");
                        this.println();
                    }
                    ((SQLTableElement)x.getTableElementList().get(i)).accept((SQLASTVisitor)this);
                }
                this.decrementIndent();
                this.println();
                this.print(')');
            }
            for (Map.Entry option : x.getTableOptions().entrySet()) {
                String key = (String)option.getKey();
                this.print(' ');
                this.print0(this.ucase ? key : key.toLowerCase());
                if ("TABLESPACE".equals(key)) {
                    this.print(' ');
                    ((SQLObject)option.getValue()).accept((SQLASTVisitor)this);
                    continue;
                }
                if ("UNION".equals(key)) {
                    this.print0(" = (");
                    ((SQLObject)option.getValue()).accept((SQLASTVisitor)this);
                    this.print(')');
                    continue;
                }
                this.print0(" = ");
                ((SQLObject)option.getValue()).accept((SQLASTVisitor)this);
            }
            if (x.getPartitioning() != null) {
                this.println();
                x.getPartitioning().accept((SQLASTVisitor)this);
            }
            if (x.getTableGroup() != null) {
                this.println();
                this.print0(this.ucase ? "TABLEGROUP " : "tablegroup ");
                x.getTableGroup().accept((SQLASTVisitor)this);
            }
            if (x.getSelect() != null) {
                this.incrementIndent();
                this.println();
                x.getSelect().accept((SQLASTVisitor)this);
                this.decrementIndent();
            }
            for (SQLCommentHint hint : x.getOptionHints()) {
                this.print(' ');
                hint.accept((SQLASTVisitor)this);
            }
            return false;
        }

        public boolean visit(SQLAlterTableStatement x) {
            int i;
            if (x.isIgnore()) {
                this.print0(this.ucase ? "ALTER IGNORE TABLE " : "alter ignore table ");
            } else {
                this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
            }
            this.processTableName((SQLExpr)x.getName());
            this.incrementIndent();
            for (i = 0; i < x.getItems().size(); ++i) {
                SQLAlterTableItem item = (SQLAlterTableItem)x.getItems().get(i);
                if (i != 0) {
                    this.print(',');
                }
                this.println();
                item.accept((SQLASTVisitor)this);
            }
            if (x.isRemovePatiting()) {
                this.println();
                this.print0(this.ucase ? "REMOVE PARTITIONING" : "remove partitioning");
            }
            if (x.isUpgradePatiting()) {
                this.println();
                this.print0(this.ucase ? "UPGRADE PARTITIONING" : "upgrade partitioning");
            }
            if (x.getTableOptions().size() > 0) {
                this.println();
            }
            this.decrementIndent();
            i = 0;
            for (Map.Entry option : x.getTableOptions().entrySet()) {
                String key = (String)option.getKey();
                if (i != 0) {
                    this.print(' ');
                }
                this.print0(this.ucase ? key : key.toLowerCase());
                if ("TABLESPACE".equals(key)) {
                    this.print(' ');
                    ((SQLObject)option.getValue()).accept((SQLASTVisitor)this);
                    continue;
                }
                if ("UNION".equals(key)) {
                    this.print0(" = (");
                    ((SQLObject)option.getValue()).accept((SQLASTVisitor)this);
                    this.print(')');
                    continue;
                }
                this.print0(" = ");
                ((SQLObject)option.getValue()).accept((SQLASTVisitor)this);
                ++i;
            }
            return false;
        }

        public boolean visit(MySqlRenameTableStatement.Item x) {
            this.processTableName((SQLExpr)x.getName());
            this.print0(this.ucase ? " TO " : " to ");
            this.processTableName((SQLExpr)x.getTo());
            return false;
        }

        public boolean visit(SQLExprTableSource x) {
            this.processTableName(x.getExpr());
            if (x.getAlias() != null) {
                this.print(' ');
                this.print0(x.getAlias());
            }
            for (int i = 0; i < x.getHintsSize(); ++i) {
                this.print(' ');
                ((SQLHint)x.getHints().get(i)).accept((SQLASTVisitor)this);
            }
            if (x.getPartitionSize() > 0) {
                this.print0(this.ucase ? " PARTITION (" : " partition (");
                this.printlnAndAccept(x.getPartitions(), ", ");
                this.print(')');
            }
            return false;
        }
    }
}

