/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.dialect;

import com.alibaba.otter.node.etl.common.datasource.DataSourceService;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialectGenerator;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.google.common.base.Function;
import com.google.common.collect.MigrateMap;
import com.google.common.collect.OtterMigrateMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbDialectFactory
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DbDialectFactory.class);
    private DataSourceService dataSourceService;
    private DbDialectGenerator dbDialectGenerator;
    private Map<Long, Map<DbMediaSource, DbDialect>> dialects = OtterMigrateMap.makeSoftValueComputingMapWithRemoveListenr((Function)new Function<Long, Map<DbMediaSource, DbDialect>>(){

        public Map<DbMediaSource, DbDialect> apply(final Long pipelineId) {
            return MigrateMap.makeComputingMap((Function)new Function<DbMediaSource, DbDialect>(){

                public DbDialect apply(final DbMediaSource source) {
                    DataSource dataSource = (DataSource)DbDialectFactory.this.dataSourceService.getDataSource(pipelineId, (DataMediaSource)source);
                    final JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
                    return (DbDialect)jdbcTemplate.execute(new ConnectionCallback(){

                        public Object doInConnection(Connection c) throws SQLException, DataAccessException {
                            DatabaseMetaData meta = c.getMetaData();
                            String databaseName = meta.getDatabaseProductName();
                            String databaseVersion = meta.getDatabaseProductVersion();
                            int databaseMajorVersion = meta.getDatabaseMajorVersion();
                            int databaseMinorVersion = meta.getDatabaseMinorVersion();
                            DbDialect dialect = DbDialectFactory.this.dbDialectGenerator.generate(jdbcTemplate, databaseName, databaseVersion, databaseMajorVersion, databaseMinorVersion, source.getType());
                            if (dialect == null) {
                                throw new UnsupportedOperationException("no dialect for" + databaseName);
                            }
                            if (logger.isInfoEnabled()) {
                                logger.info(String.format("--- DATABASE: %s, SCHEMA: %s ---", databaseName, dialect.getDefaultSchema() == null ? dialect.getDefaultCatalog() : dialect.getDefaultSchema()));
                            }
                            return dialect;
                        }
                    });
                }
            });
        }
    }, (OtterMigrateMap.OtterRemovalListener)new OtterMigrateMap.OtterRemovalListener<Long, Map<DbMediaSource, DbDialect>>(){

        public void onRemoval(Long pipelineId, Map<DbMediaSource, DbDialect> dialect) {
            if (dialect == null) {
                return;
            }
            for (DbDialect dbDialect : dialect.values()) {
                dbDialect.destory();
            }
        }
    });

    public DbDialect getDbDialect(Long pipelineId, DbMediaSource source) {
        return this.dialects.get(pipelineId).get(source);
    }

    public void destory(Long pipelineId) {
        Map<DbMediaSource, DbDialect> dialect = this.dialects.remove(pipelineId);
        if (dialect != null) {
            for (DbDialect dbDialect : dialect.values()) {
                dbDialect.destory();
            }
        }
    }

    public void destroy() throws Exception {
        HashSet<Long> pipelineIds = new HashSet<Long>(this.dialects.keySet());
        for (Long pipelineId : pipelineIds) {
            this.destory(pipelineId);
        }
    }

    public void setDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public void setDbDialectGenerator(DbDialectGenerator dbDialectGenerator) {
        this.dbDialectGenerator = dbDialectGenerator;
    }
}

