/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.dialect;

import com.alibaba.otter.node.etl.common.datasource.DataSourceService;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.SqlTemplate;
import com.alibaba.otter.shared.common.utils.meta.DdlUtils;
import com.alibaba.otter.shared.common.utils.meta.DdlUtilsFilter;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.ddlutils.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public abstract class AbstractDbDialect
implements DbDialect {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractDbDialect.class);
    protected int databaseMajorVersion;
    protected int databaseMinorVersion;
    protected String databaseName;
    protected DataSourceService dataSourceService;
    protected SqlTemplate sqlTemplate;
    protected JdbcTemplate jdbcTemplate;
    protected TransactionTemplate transactionTemplate;
    protected LobHandler lobHandler;
    protected Map<List<String>, Table> tables;

    public AbstractDbDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler) {
        this.jdbcTemplate = jdbcTemplate;
        this.lobHandler = lobHandler;
        this.transactionTemplate = new TransactionTemplate();
        this.transactionTemplate.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager(jdbcTemplate.getDataSource()));
        this.transactionTemplate.setPropagationBehavior(3);
        jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection c) throws SQLException, DataAccessException {
                DatabaseMetaData meta = c.getMetaData();
                AbstractDbDialect.this.databaseName = meta.getDatabaseProductName();
                AbstractDbDialect.this.databaseMajorVersion = meta.getDatabaseMajorVersion();
                AbstractDbDialect.this.databaseMinorVersion = meta.getDatabaseMinorVersion();
                return null;
            }
        });
        this.initTables(jdbcTemplate);
    }

    public AbstractDbDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler, String name, int majorVersion, int minorVersion) {
        this.jdbcTemplate = jdbcTemplate;
        this.lobHandler = lobHandler;
        this.transactionTemplate = new TransactionTemplate();
        this.transactionTemplate.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager(jdbcTemplate.getDataSource()));
        this.transactionTemplate.setPropagationBehavior(3);
        this.databaseName = name;
        this.databaseMajorVersion = majorVersion;
        this.databaseMinorVersion = minorVersion;
        this.initTables(jdbcTemplate);
    }

    @Override
    public Table findTable(String schema, String table, boolean useCache) {
        List<String> key = Arrays.asList(schema, table);
        if (!useCache) {
            this.tables.remove(key);
        }
        return this.tables.get(key);
    }

    @Override
    public Table findTable(String schema, String table) {
        return this.findTable(schema, table, true);
    }

    @Override
    public void reloadTable(String schema, String table) {
        if (StringUtils.isNotEmpty((String)table)) {
            this.tables.remove(Arrays.asList(schema, table));
        } else {
            this.tables.clear();
        }
    }

    @Override
    public String getName() {
        return this.databaseName;
    }

    @Override
    public int getMajorVersion() {
        return this.databaseMajorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Override
    public String getVersion() {
        return this.databaseMajorVersion + "." + this.databaseMinorVersion;
    }

    @Override
    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public SqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    @Override
    public boolean isDRDS() {
        return false;
    }

    @Override
    public String getShardColumns(String schema, String table) {
        return null;
    }

    @Override
    public void destory() {
    }

    private void initTables(final JdbcTemplate jdbcTemplate) {
        this.tables = OtterMigrateMap.makeSoftValueComputingMap((Function)new Function<List<String>, Table>(){

            public Table apply(List<String> names) {
                Assert.isTrue((names.size() == 2 ? 1 : 0) != 0);
                try {
                    AbstractDbDialect.this.beforeFindTable(jdbcTemplate, names.get(0), names.get(0), names.get(1));
                    DdlUtilsFilter filter = AbstractDbDialect.this.getDdlUtilsFilter(jdbcTemplate, names.get(0), names.get(0), names.get(1));
                    Table table = DdlUtils.findTable((JdbcTemplate)jdbcTemplate, (String)names.get(0), (String)names.get(0), (String)names.get(1), (DdlUtilsFilter)filter);
                    AbstractDbDialect.this.afterFindTable(table, jdbcTemplate, names.get(0), names.get(0), names.get(1));
                    if (table == null) {
                        throw new NestableRuntimeException("no found table [" + names.get(0) + "." + names.get(1) + "] , pls check");
                    }
                    return table;
                }
                catch (Exception e) {
                    throw new NestableRuntimeException("find table [" + names.get(0) + "." + names.get(1) + "] error", (Throwable)e);
                }
            }
        });
    }

    protected DdlUtilsFilter getDdlUtilsFilter(JdbcTemplate jdbcTemplate, String catalogName, String schemaName, String tableName) {
        return null;
    }

    protected void beforeFindTable(JdbcTemplate jdbcTemplate, String catalogName, String schemaName, String tableName) {
    }

    protected void afterFindTable(Table table, JdbcTemplate jdbcTemplate, String catalogName, String schemaName, String tableName) {
    }
}

