/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.common.statistics.impl;

import com.alibaba.otter.node.common.communication.NodeCommmunicationClient;
import com.alibaba.otter.node.common.statistics.StatisticsClientService;
import com.alibaba.otter.shared.common.model.statistics.delay.DelayCount;
import com.alibaba.otter.shared.common.model.statistics.table.TableStat;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputStat;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import com.alibaba.otter.shared.communication.core.model.Callback;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.model.statistics.DelayCountEvent;
import com.alibaba.otter.shared.communication.model.statistics.TableStatEvent;
import com.alibaba.otter.shared.communication.model.statistics.ThroughputStatEvent;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class StatisticsClientServiceImpl
implements StatisticsClientService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsClientServiceImpl.class);
    private static final int DEFAULT_POOL = 10;
    private BlockingQueue<DelayCountEvent> delayCountStatsBuffer = new LinkedBlockingQueue<DelayCountEvent>(10000);
    private static ScheduledThreadPoolExecutor scheduler;
    private NodeCommmunicationClient nodeCommmunicationClient;

    @Override
    public void sendIncDelayCount(DelayCount delayCount) {
        DelayCountEvent event = new DelayCountEvent();
        event.setCount(delayCount);
        event.setAction(DelayCountEvent.Action.INC);
        boolean result = this.delayCountStatsBuffer.offer(event);
        if (result) {
            logger.info("add IncDelayCount to send with {}", (Object)delayCount);
        } else {
            logger.warn("add IncDelayCount failed by buffer is full with {}", (Object)delayCount);
        }
    }

    @Override
    public void sendDecDelayCount(DelayCount delayCount) {
        DelayCountEvent event = new DelayCountEvent();
        event.setCount(delayCount);
        event.setAction(DelayCountEvent.Action.DEC);
        boolean result = this.delayCountStatsBuffer.offer(event);
        if (result) {
            logger.info("add sendDecDelayCount to send with {}", (Object)delayCount);
        } else {
            logger.warn("add sendDecDelayCount failed by buffer is full with {}", (Object)delayCount);
        }
    }

    @Override
    public void sendResetDelayCount(DelayCount delayCount) {
        DelayCountEvent event = new DelayCountEvent();
        event.setCount(delayCount);
        event.setAction(DelayCountEvent.Action.RESET);
        boolean result = this.delayCountStatsBuffer.offer(event);
        if (result) {
            logger.info("add sendResetDelayCount to send with {}", (Object)delayCount);
        } else {
            logger.warn("add sendResetDelayCount failed by buffer is full with {}", (Object)delayCount);
        }
    }

    @Override
    public void sendThroughputs(final List<ThroughputStat> stats) {
        ThroughputStatEvent event = new ThroughputStatEvent();
        event.setStats(stats);
        this.nodeCommmunicationClient.callManager((Event)event, (Callback)new Callback<Object>(){

            public void call(Object event) {
                logger.info("sendThroughput successed for {}", (Object)stats);
            }
        });
    }

    @Override
    public void sendTableStats(final List<TableStat> stats) {
        TableStatEvent event = new TableStatEvent();
        event.setStats(stats);
        this.nodeCommmunicationClient.callManager((Event)event, (Callback)new Callback<Object>(){

            public void call(Object event) {
                logger.info("sendTableStats successed for {}", (Object)stats);
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        scheduler = new ScheduledThreadPoolExecutor(10, (ThreadFactory)new NamedThreadFactory("Otter-Statistics-Client"), new ThreadPoolExecutor.CallerRunsPolicy());
        scheduler.submit(new Runnable(){

            @Override
            public void run() {
                StatisticsClientServiceImpl.this.doSendDelayCountEvent();
            }
        });
    }

    private void doSendDelayCountEvent() {
        DelayCountEvent event = null;
        while (true) {
            try {
                while (true) {
                    event = this.delayCountStatsBuffer.take();
                    this.nodeCommmunicationClient.callManager((Event)event);
                    logger.info("sendDelayCountEvent successed for {}", (Object)event);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                LockSupport.parkNanos(TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS));
                continue;
            }
            break;
        }
    }

    public void setNodeCommmunicationClient(NodeCommmunicationClient nodeCommmunicationClient) {
        this.nodeCommmunicationClient = nodeCommmunicationClient;
    }
}

