/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.common.config.impl;

import com.alibaba.otter.node.common.communication.NodeCommmunicationClient;
import com.alibaba.otter.node.common.config.NodeTaskListener;
import com.alibaba.otter.node.common.config.NodeTaskService;
import com.alibaba.otter.node.common.config.impl.InternalConfigClientService;
import com.alibaba.otter.node.common.config.model.NodeTask;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.core.model.EventType;
import com.alibaba.otter.shared.communication.model.arbitrate.StopNodeEvent;
import com.alibaba.otter.shared.communication.model.config.ConfigEventType;
import com.alibaba.otter.shared.communication.model.config.FindTaskEvent;
import com.alibaba.otter.shared.communication.model.config.NotifyChannelEvent;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class NodeTaskServiceImpl
implements NodeTaskService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(NodeTaskService.class);
    private NodeCommmunicationClient nodeCommmunicationClient;
    private InternalConfigClientService configClientService;
    private List<NodeTask> allTasks = Collections.synchronizedList(new ArrayList());
    private List<NodeTask> incTasks = Collections.synchronizedList(new ArrayList());
    private List<NodeTaskListener> listeners = Collections.synchronizedList(new ArrayList());

    public NodeTaskServiceImpl() {
        CommunicationRegistry.regist((EventType)ConfigEventType.notifyChannel, (Object)this);
    }

    @Override
    public synchronized List<NodeTask> listAllNodeTasks() {
        return this.allTasks;
    }

    public void afterPropertiesSet() throws Exception {
        this.initNodeTask();
        if (!this.notifyListener()) {
            throw new RuntimeException("init node task failed.");
        }
    }

    private synchronized List<NodeTask> mergeIncNodeTasks() {
        ArrayList<NodeTask> tasks = new ArrayList<NodeTask>(this.incTasks);
        this.incTasks.clear();
        if (logger.isInfoEnabled()) {
            logger.info("##merge all NodeTask {}", (Object)this.printNodeTasks(tasks));
        }
        this.merge(this.allTasks, tasks);
        if (logger.isInfoEnabled()) {
            logger.info("##now all NodeTask {}", (Object)this.printNodeTasks(this.allTasks));
        }
        return tasks;
    }

    private void initNodeTask() {
        Node node = this.configClientService.currentNode();
        FindTaskEvent event = new FindTaskEvent();
        event.setNid(node.getId());
        Object obj = this.nodeCommmunicationClient.callManager((Event)event);
        if (obj != null) {
            List channels = (List)obj;
            for (Channel channel : channels) {
                this.processNodeTask(channel);
            }
        }
    }

    private void processNodeTask(Channel channel) {
        List<NodeTask> addTasks = this.parseNodeTask(channel);
        if (logger.isInfoEnabled()) {
            logger.info("##merge channel[{}] inc NodeTask {}", (Object)channel.getId(), (Object)this.printNodeTasks(addTasks));
        }
        ArrayList<NodeTask> tasks = new ArrayList<NodeTask>(this.incTasks);
        this.merge(tasks, addTasks);
        this.merge(this.incTasks, this.retain(tasks, this.allTasks));
        if (logger.isInfoEnabled()) {
            logger.info("##now inc NodeTask {}", (Object)this.printNodeTasks(this.incTasks));
        }
    }

    private String printNodeTasks(List<NodeTask> tasks) {
        StringBuilder builder = new StringBuilder();
        for (NodeTask task : tasks) {
            builder.append("\n=========================");
            builder.append("pipeline:" + task.getPipeline().getId()).append("\n");
            builder.append("\t").append(task.getStage()).append("\n");
            builder.append("\t").append(task.getEvent()).append("\n");
            builder.append("\t").append("shutdown:").append(task.isShutdown()).append("\n");
        }
        return builder.toString();
    }

    private List<NodeTask> parseNodeTask(Channel channel) {
        ArrayList<NodeTask> tasks = new ArrayList<NodeTask>();
        List pipelines = channel.getPipelines();
        Long nid = this.configClientService.currentNode().getId();
        NodeTask.TaskEvent taksEvent = null;
        if (channel.getStatus().isStart()) {
            taksEvent = NodeTask.TaskEvent.CREATE;
        } else if (channel.getStatus().isStop()) {
            taksEvent = NodeTask.TaskEvent.DELETE;
        } else if (channel.getStatus().isPause()) {
            taksEvent = NodeTask.TaskEvent.CREATE;
        }
        for (Pipeline pipeline : pipelines) {
            Object node2;
            List sNodes = pipeline.getSelectNodes();
            for (Object node2 : sNodes) {
                if (!nid.equals(node2.getId())) continue;
                NodeTask task = new NodeTask();
                task.setPipeline(pipeline);
                NodeTask matchTask = this.getMatchTask(tasks, task);
                if (matchTask == null) {
                    matchTask = task;
                    tasks.add(task);
                }
                matchTask.setPipeline(pipeline);
                matchTask.getStage().add(StageType.SELECT);
                matchTask.getEvent().add(taksEvent);
            }
            List eNodes = pipeline.getExtractNodes();
            node2 = eNodes.iterator();
            while (node2.hasNext()) {
                Node node3 = (Node)node2.next();
                if (!nid.equals(node3.getId())) continue;
                NodeTask task = new NodeTask();
                task.setPipeline(pipeline);
                NodeTask matchTask = this.getMatchTask(tasks, task);
                if (matchTask == null) {
                    matchTask = task;
                    tasks.add(task);
                }
                matchTask.getStage().add(StageType.EXTRACT);
                matchTask.getEvent().add(taksEvent);
            }
            List tlNodes = pipeline.getLoadNodes();
            for (Node node4 : tlNodes) {
                if (!nid.equals(node4.getId())) continue;
                NodeTask task = new NodeTask();
                task.setPipeline(pipeline);
                NodeTask matchTask = this.getMatchTask(tasks, task);
                if (matchTask == null) {
                    matchTask = task;
                    tasks.add(task);
                }
                matchTask.getStage().add(StageType.TRANSFORM);
                matchTask.getEvent().add(taksEvent);
                matchTask.getStage().add(StageType.LOAD);
                matchTask.getEvent().add(taksEvent);
            }
        }
        List pipelineIds = Lists.transform((List)channel.getPipelines(), (Function)new Function<Pipeline, Long>(){

            public Long apply(Pipeline input) {
                return input.getId();
            }
        });
        for (NodeTask task : this.allTasks) {
            Pipeline pipeline = task.getPipeline();
            if (pipeline.getChannelId().equals(channel.getId()) && !pipelineIds.contains(pipeline.getId())) {
                NodeTask deletePipelineTask = new NodeTask();
                deletePipelineTask.setPipeline(pipeline);
                List<StageType> stages = task.getStage();
                List<NodeTask.TaskEvent> events = task.getEvent();
                for (int i = 0; i < stages.size(); ++i) {
                    StageType stage = stages.get(i);
                    NodeTask.TaskEvent event = events.get(i);
                    if (!event.isCreate()) continue;
                    deletePipelineTask.getStage().add(stage);
                    deletePipelineTask.getEvent().add(NodeTask.TaskEvent.DELETE);
                }
                tasks.add(deletePipelineTask);
            }
            if (!pipelineIds.contains(pipeline.getId())) continue;
            boolean needAdd = false;
            NodeTask matchTask = this.getMatchTask(tasks, task);
            if (matchTask == null) {
                matchTask = new NodeTask();
                matchTask.setPipeline(pipeline);
                needAdd = true;
            }
            List<StageType> stages = task.getStage();
            List<NodeTask.TaskEvent> events = task.getEvent();
            for (int i = 0; i < stages.size(); ++i) {
                StageType stage = stages.get(i);
                NodeTask.TaskEvent event = events.get(i);
                NodeTask.TaskEvent matchEvent = this.getMatchStage(matchTask, stage);
                if (matchEvent != null || !event.isCreate()) continue;
                matchTask.getStage().add(stage);
                matchTask.getEvent().add(NodeTask.TaskEvent.DELETE);
            }
            if (!needAdd || matchTask.getStage().size() <= 0) continue;
            tasks.add(matchTask);
        }
        for (NodeTask task : tasks) {
            boolean shutdown = true;
            for (NodeTask.TaskEvent event : task.getEvent()) {
                shutdown &= event.isDelete();
            }
            task.setShutdown(shutdown);
        }
        return tasks;
    }

    private List<NodeTask> retain(List<NodeTask> targetTasks, List<NodeTask> sourceTasks) {
        ArrayList<NodeTask> result = new ArrayList<NodeTask>();
        for (NodeTask task : targetTasks) {
            NodeTask sourceTask = this.getMatchTask(sourceTasks, task);
            if (sourceTask != null) {
                NodeTask resultTask = this.retain(task, sourceTask);
                if (resultTask == null) continue;
                result.add(resultTask);
                continue;
            }
            result.add(task);
        }
        return result;
    }

    private NodeTask retain(NodeTask targetTask, NodeTask sourceTask) {
        NodeTask.TaskEvent event;
        StageType stage;
        int i;
        List<StageType> stages = targetTask.getStage();
        List<NodeTask.TaskEvent> events = targetTask.getEvent();
        ArrayList<StageType> mergeStates = new ArrayList<StageType>();
        ArrayList<NodeTask.TaskEvent> mergeEvents = new ArrayList<NodeTask.TaskEvent>();
        for (i = 0; i < stages.size(); ++i) {
            stage = stages.get(i);
            event = events.get(i);
            NodeTask.TaskEvent sourceEvent = this.getMatchStage(sourceTask, stage);
            if (sourceEvent == null || sourceEvent == event) continue;
            mergeStates.add(stage);
            mergeEvents.add(event);
        }
        for (i = 0; i < stages.size(); ++i) {
            stage = stages.get(i);
            event = events.get(i);
            if (this.getMatchStage(sourceTask, stage) != null) continue;
            mergeStates.add(stage);
            mergeEvents.add(event);
        }
        if (mergeStates.size() > 0) {
            NodeTask result = new NodeTask();
            result.setPipeline(targetTask.getPipeline());
            result.setEvent(mergeEvents);
            result.setStage(mergeStates);
            result.setShutdown(targetTask.isShutdown());
            return result;
        }
        return null;
    }

    private void merge(List<NodeTask> targetTasks, List<NodeTask> sourceTasks) {
        for (NodeTask task : sourceTasks) {
            NodeTask targetTask = this.getMatchTask(targetTasks, task);
            if (targetTask != null) {
                this.merge(targetTask, task);
                continue;
            }
            targetTasks.add(task);
        }
    }

    private NodeTask getMatchTask(List<NodeTask> tasks, NodeTask match) {
        for (NodeTask task : tasks) {
            if (!match.getPipeline().getId().equals(task.getPipeline().getId())) continue;
            return task;
        }
        return null;
    }

    private void merge(NodeTask target, NodeTask source) {
        List<StageType> stages = target.getStage();
        List<NodeTask.TaskEvent> events = target.getEvent();
        ArrayList<StageType> mergeStates = new ArrayList<StageType>();
        ArrayList<NodeTask.TaskEvent> mergeEvents = new ArrayList<NodeTask.TaskEvent>();
        for (int i = 0; i < stages.size(); ++i) {
            StageType stage = stages.get(i);
            NodeTask.TaskEvent event = events.get(i);
            mergeStates.add(stage);
            NodeTask.TaskEvent sourceEvent = this.getMatchStage(source, stage);
            if (sourceEvent == null) {
                mergeEvents.add(event);
                continue;
            }
            mergeEvents.add(sourceEvent);
        }
        List<StageType> sourceStages = source.getStage();
        List<NodeTask.TaskEvent> sourceEvents = source.getEvent();
        for (int i = 0; i < sourceStages.size(); ++i) {
            StageType stage = sourceStages.get(i);
            NodeTask.TaskEvent event = sourceEvents.get(i);
            if (mergeStates.contains(stage)) continue;
            mergeStates.add(stage);
            mergeEvents.add(event);
        }
        target.setEvent(mergeEvents);
        target.setStage(mergeStates);
        target.setShutdown(source.isShutdown());
    }

    private NodeTask.TaskEvent getMatchStage(NodeTask nodeTask, StageType stage) {
        List<StageType> stages = nodeTask.getStage();
        List<NodeTask.TaskEvent> events = nodeTask.getEvent();
        for (int i = 0; i < stages.size(); ++i) {
            if (stages.get(i) != stage) continue;
            return events.get(i);
        }
        return null;
    }

    protected synchronized boolean onNotifyChannel(NotifyChannelEvent event) {
        this.configClientService.createOrUpdateChannel(event.getChannel());
        this.processNodeTask(event.getChannel());
        return this.notifyListener();
    }

    private synchronized boolean notifyListener() {
        boolean result = true;
        ArrayList<NodeTask> incNodeTask = new ArrayList<NodeTask>(this.incTasks);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            for (NodeTaskListener listener : this.listeners) {
                result &= listener.process(incNodeTask);
            }
            if (result) {
                this.mergeIncNodeTasks();
            } else {
                this.incTasks.clear();
                if (logger.isInfoEnabled()) {
                    logger.info("##notify listener error {}", (Object)this.printNodeTasks(incNodeTask));
                }
            }
        }
        return result;
    }

    @Override
    public void stopNode() {
        Node node = this.configClientService.currentNode();
        StopNodeEvent event = new StopNodeEvent();
        event.setNid(node.getId());
        this.nodeCommmunicationClient.callManager((Event)event);
    }

    @Override
    public void addListener(NodeTaskListener listener) {
        Assert.notNull((Object)listener);
        this.listeners.add(listener);
        this.notifyListener();
    }

    public void setNodeCommmunicationClient(NodeCommmunicationClient nodeCommmunicationClient) {
        this.nodeCommmunicationClient = nodeCommmunicationClient;
    }

    public void setConfigClientService(InternalConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setListeners(List<NodeTaskListener> listeners) {
        this.listeners = listeners;
    }
}

