/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.common.config.impl;

import com.alibaba.otter.node.common.communication.NodeCommmunicationClient;
import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.common.config.impl.InternalConfigClientService;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfig;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigRegistry;
import com.alibaba.otter.shared.common.model.config.ConfigException;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.utils.cache.RefreshMemoryMirror;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.model.config.FindChannelEvent;
import com.alibaba.otter.shared.communication.model.config.FindNodeEvent;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ConfigClientServiceImpl
implements InternalConfigClientService,
ArbitrateConfig,
InitializingBean {
    private static final String NID_NAME = "nid";
    private static final Long DEFAULT_PERIOD = 60000L;
    private static final Logger logger = LoggerFactory.getLogger(ConfigClientService.class);
    private Long timeout = DEFAULT_PERIOD;
    private Long nid;
    private NodeCommmunicationClient nodeCommmunicationClient;
    private RefreshMemoryMirror<Long, Channel> channelCache;
    private Map<Long, Long> channelMapping;
    private RefreshMemoryMirror<Long, Node> nodeCache;

    public ConfigClientServiceImpl() {
        ArbitrateConfigRegistry.regist((ArbitrateConfig)this);
    }

    @Override
    public Node currentNode() {
        Node node = (Node)this.nodeCache.get((Object)this.nid);
        if (node == null) {
            throw new ConfigException("nid:" + this.nid + " in manager[" + this.nodeCommmunicationClient.getManagerAddress() + "]is not found!");
        }
        return node;
    }

    @Override
    public Channel findChannel(Long channelId) {
        return (Channel)this.channelCache.get((Object)channelId);
    }

    @Override
    public Channel findChannelByPipelineId(Long pipelineId) {
        Long channelId = this.channelMapping.get(pipelineId);
        return (Channel)this.channelCache.get((Object)channelId);
    }

    @Override
    public Pipeline findOppositePipeline(Long pipelineId) {
        Long channelId = this.channelMapping.get(pipelineId);
        Channel channel = (Channel)this.channelCache.get((Object)channelId);
        List pipelines = channel.getPipelines();
        for (Pipeline pipeline : pipelines) {
            if (pipeline.getId().equals(pipelineId)) continue;
            return pipeline;
        }
        return null;
    }

    @Override
    public Pipeline findPipeline(Long pipelineId) {
        Long channelId = this.channelMapping.get(pipelineId);
        Channel channel = (Channel)this.channelCache.get((Object)channelId);
        List pipelines = channel.getPipelines();
        for (Pipeline pipeline : pipelines) {
            if (!pipeline.getId().equals(pipelineId)) continue;
            return pipeline;
        }
        throw new ConfigException("no pipeline for pipelineId[" + pipelineId + "]");
    }

    @Override
    public Node findNode(Long nid) {
        return (Node)this.nodeCache.get((Object)nid);
    }

    public void afterPropertiesSet() throws Exception {
        String nid = System.getProperty(NID_NAME);
        if (StringUtils.isEmpty((String)nid)) {
            throw new ConfigException("nid is not set!");
        }
        this.nid = Long.valueOf(nid);
        this.channelMapping = OtterMigrateMap.makeComputingMap((Function)new Function<Long, Long>(){

            public Long apply(Long pipelineId) {
                FindChannelEvent event = new FindChannelEvent();
                event.setPipelineId(pipelineId);
                try {
                    Object obj = ConfigClientServiceImpl.this.nodeCommmunicationClient.callManager((Event)event);
                    if (obj != null && obj instanceof Channel) {
                        Channel channel = (Channel)obj;
                        ConfigClientServiceImpl.this.updateMapping(channel, pipelineId);
                        ConfigClientServiceImpl.this.channelCache.put((Object)channel.getId(), (Object)channel);
                        return channel.getId();
                    }
                }
                catch (Exception e) {
                    logger.error("call_manager_error", (Object)event.toString(), (Object)e);
                }
                throw new ConfigException("No Such Channel by pipelineId[" + pipelineId + "]");
            }
        });
        this.nodeCache = new RefreshMemoryMirror(this.timeout, (RefreshMemoryMirror.ComputeFunction)new RefreshMemoryMirror.ComputeFunction<Long, Node>(){

            public Node apply(Long key, Node oldValue) {
                FindNodeEvent event = new FindNodeEvent();
                event.setNid(key);
                try {
                    Object obj = ConfigClientServiceImpl.this.nodeCommmunicationClient.callManager((Event)event);
                    if (obj != null && obj instanceof Node) {
                        return (Node)obj;
                    }
                    throw new ConfigException("No Such Node by id[" + key + "]");
                }
                catch (Exception e) {
                    logger.error("call_manager_error", (Object)event.toString(), (Object)e);
                    return oldValue;
                }
            }
        });
        this.channelCache = new RefreshMemoryMirror(this.timeout, (RefreshMemoryMirror.ComputeFunction)new RefreshMemoryMirror.ComputeFunction<Long, Channel>(){

            public Channel apply(Long key, Channel oldValue) {
                FindChannelEvent event = new FindChannelEvent();
                event.setChannelId(key);
                try {
                    Object obj = ConfigClientServiceImpl.this.nodeCommmunicationClient.callManager((Event)event);
                    if (obj != null && obj instanceof Channel) {
                        ConfigClientServiceImpl.this.updateMapping((Channel)obj, null);
                        return (Channel)obj;
                    }
                    throw new ConfigException("No Such Channel by pipelineId[" + key + "]");
                }
                catch (Exception e) {
                    logger.error("call_manager_error", (Object)event.toString(), (Object)e);
                    return oldValue;
                }
            }
        });
    }

    @Override
    public void createOrUpdateChannel(Channel channel) {
        this.channelCache.put((Object)channel.getId(), (Object)channel);
        this.updateMapping(channel, null);
    }

    private void updateMapping(Channel channel, Long excludeId) {
        Long channelId = channel.getId();
        List pipelines = channel.getPipelines();
        for (Pipeline pipeline : pipelines) {
            if (excludeId != null && pipeline.getId().equals(excludeId)) continue;
            this.channelMapping.put(pipeline.getId(), channelId);
        }
    }

    public void setNodeCommmunicationClient(NodeCommmunicationClient nodeCommmunicationClient) {
        this.nodeCommmunicationClient = nodeCommmunicationClient;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }
}

