/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.common.communication;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.shared.communication.core.CommunicationEndpoint;
import com.alibaba.otter.shared.communication.core.impl.dubbo.DubboCommunicationEndpoint;
import com.alibaba.otter.shared.communication.core.impl.rmi.RmiCommunicationEndpoint;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class NodeCommunicationEndpoint
implements InitializingBean,
DisposableBean {
    private CommunicationEndpoint endpoint;
    private ConfigClientService configClientService;

    public void afterPropertiesSet() throws Exception {
        Long port = this.configClientService.currentNode().getPort();
        if (this.endpoint instanceof RmiCommunicationEndpoint) {
            RmiCommunicationEndpoint rmiEndpoint = (RmiCommunicationEndpoint)this.endpoint;
            rmiEndpoint.setPort(port.intValue());
        }
        if (this.endpoint instanceof DubboCommunicationEndpoint) {
            DubboCommunicationEndpoint dubboEndpoint = (DubboCommunicationEndpoint)this.endpoint;
            dubboEndpoint.setPort(port.intValue());
        }
        this.endpoint.initial();
    }

    public void destroy() throws Exception {
        this.endpoint.destory();
    }

    public void setEndpoint(CommunicationEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }
}

