/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.common.communication;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.communication.core.CommunicationClient;
import com.alibaba.otter.shared.communication.core.exception.CommunicationException;
import com.alibaba.otter.shared.communication.core.impl.DefaultCommunicationClientImpl;
import com.alibaba.otter.shared.communication.core.model.Callback;
import com.alibaba.otter.shared.communication.core.model.Event;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.beans.factory.DisposableBean;

public class NodeCommmunicationClient
implements DisposableBean {
    private CommunicationClient delegate;
    private ConfigClientService configClientService;
    private List<String> managerAddress;
    private volatile int index = 0;

    public Object call(Long nid, Event event) {
        return this.delegate.call(this.convertToAddress(nid), event);
    }

    public void call(Long nid, Event event, Callback callback) {
        this.delegate.call(this.convertToAddress(nid), event, callback);
    }

    public Object callManager(Event event) {
        CommunicationException ex = null;
        Object object = null;
        for (int i = this.index; i < this.index + this.managerAddress.size(); ++i) {
            String address = this.managerAddress.get(i % this.managerAddress.size());
            try {
                object = this.delegate.call(address, event);
                this.index = i;
                return object;
            }
            catch (CommunicationException e) {
                ex = e;
                continue;
            }
        }
        throw ex;
    }

    public void callManager(final Event event, final Callback callback) {
        if (this.delegate instanceof DefaultCommunicationClientImpl) {
            ((DefaultCommunicationClientImpl)this.delegate).submit(new Runnable(){

                @Override
                public void run() {
                    Object obj = NodeCommmunicationClient.this.callManager(event);
                    callback.call(obj);
                }
            });
        }
    }

    private String convertToAddress(Long nid) {
        Node node = this.configClientService.findNode(nid);
        if (node.getParameters().getUseExternalIp().booleanValue()) {
            return node.getParameters().getExternalIp() + ":" + node.getPort();
        }
        return node.getIp() + ":" + node.getPort();
    }

    public void destroy() throws Exception {
    }

    public void setDelegate(CommunicationClient delegate) {
        this.delegate = delegate;
    }

    public void setManagerAddress(String managerAddress) {
        String server = StringUtils.replace((String)managerAddress, (String)";", (String)",");
        String[] servers = StringUtils.split((String)server, (char)',');
        this.managerAddress = Arrays.asList(servers);
        this.index = RandomUtils.nextInt((int)this.managerAddress.size());
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public String getManagerAddress() {
        return StringUtils.join(this.managerAddress, (String)",");
    }
}

