/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.instance.manager.plain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.common.CanalLifeCycle;
import com.alibaba.otter.canal.instance.manager.plain.HttpHelper;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanal;
import com.alibaba.otter.canal.protocol.SecurityUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class PlainCanalConfigClient
extends AbstractCanalLifeCycle
implements CanalLifeCycle {
    private static final Integer REQUEST_TIMEOUT = 5000;
    private String configURL;
    private String user;
    private String passwd;
    private HttpHelper httpHelper;
    private String localIp;
    private int adminPort;
    private boolean autoRegister;
    private String autoCluster;

    public PlainCanalConfigClient(String configURL, String user, String passwd, String localIp, int adminPort, boolean autoRegister, String autoCluster) {
        this(configURL, user, passwd, localIp, adminPort);
        this.autoCluster = autoCluster;
        this.autoRegister = autoRegister;
    }

    public PlainCanalConfigClient(String configURL, String user, String passwd, String localIp, int adminPort) {
        this.configURL = configURL;
        this.configURL = !StringUtils.startsWithIgnoreCase((String)configURL, (String)"http") ? "http://" + configURL : configURL;
        this.user = user;
        this.passwd = passwd;
        this.httpHelper = new HttpHelper();
        this.localIp = StringUtils.isEmpty((String)localIp) ? "127.0.0.1" : localIp;
        this.adminPort = adminPort;
    }

    public PlainCanal findServer(String md5) {
        if (StringUtils.isEmpty((String)md5)) {
            md5 = "";
        }
        String url = this.configURL + "/api/v1/config/server_polling?ip=" + this.localIp + "&port=" + this.adminPort + "&md5=" + md5 + "&register=" + (this.autoRegister ? 1 : 0) + "&cluster=" + this.autoCluster;
        return this.queryConfig(url);
    }

    public PlainCanal findInstance(String destination, String md5) {
        if (StringUtils.isEmpty((String)md5)) {
            md5 = "";
        }
        String url = this.configURL + "/api/v1/config/instance_polling/" + destination + "?md5=" + md5;
        return this.queryConfig(url);
    }

    public String findInstances(String md5) {
        if (StringUtils.isEmpty((String)md5)) {
            md5 = "";
        }
        String url = this.configURL + "/api/v1/config/instances_polling?md5=" + md5 + "&ip=" + this.localIp + "&port=" + this.adminPort;
        ResponseModel<CanalConfig> config = this.doQuery(url);
        if (config.data != null) {
            return ((CanalConfig)config.data).content;
        }
        return null;
    }

    private PlainCanal queryConfig(String url) {
        try {
            ResponseModel<CanalConfig> config = this.doQuery(url);
            return this.processData((CanalConfig)config.data);
        }
        catch (Throwable e) {
            throw new CanalException("load manager config failed.", e);
        }
    }

    private ResponseModel<CanalConfig> doQuery(String url) {
        HashMap<String, String> heads = new HashMap<String, String>();
        heads.put("user", this.user);
        heads.put("passwd", this.passwd);
        String response = this.httpHelper.get(url, heads, REQUEST_TIMEOUT);
        ResponseModel resp = (ResponseModel)JSONObject.parseObject((String)response, (TypeReference)new TypeReference<ResponseModel<CanalConfig>>(){}, (Feature[])new Feature[0]);
        if (!HttpHelper.REST_STATE_OK.equals(resp.code)) {
            throw new CanalException("requestGet for canal config error: " + resp.message);
        }
        return resp;
    }

    private PlainCanal processData(CanalConfig config) throws IOException, NoSuchAlgorithmException {
        Properties properties = new Properties();
        String md5 = null;
        String status = null;
        if (config == null || !StringUtils.isNotEmpty((String)config.content)) {
            return null;
        }
        md5 = SecurityUtil.md5String((String)config.content);
        status = config.status;
        properties.load(new ByteArrayInputStream(config.content.getBytes(StandardCharsets.UTF_8)));
        return new PlainCanal(properties, status, md5);
    }

    private static class CanalConfig {
        public String content;
        public String status;

        private CanalConfig() {
        }
    }

    private static class ResponseModel<T> {
        public Integer code;
        public String message;
        public T data;

        private ResponseModel() {
        }
    }
}

