/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.derby;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.mapper.AbstractMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public class ConfigInfoMapperByDerby
extends AbstractMapper
implements ConfigInfoMapper {
    private static final String DATA_ID = "dataId";
    private static final String GROUP = "group";
    private static final String APP_NAME = "appName";
    private static final String CONTENT = "content";
    private static final String TENANT = "tenant";

    @Override
    public String findConfigMaxId() {
        return "SELECT max(id) FROM config_info";
    }

    @Override
    public String findAllDataIdAndGroup() {
        return "SELECT DISTINCT data_id, group_id FROM config_info";
    }

    @Override
    public String findConfigInfoByAppCountRows() {
        return "SELECT count(*) FROM config_info WHERE tenant_id LIKE ? AND app_name = ?";
    }

    @Override
    public String findConfigInfoByAppFetchRows(int startRow, int pageSize) {
        return "SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? AND app_name = ? OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String configInfoLikeTenantCount() {
        return "SELECT count(*) FROM config_info WHERE tenant_id LIKE ?";
    }

    @Override
    public String getTenantIdList(int startRow, int pageSize) {
        return "SELECT tenant_id FROM config_info WHERE tenant_id != '' GROUP BY tenant_id OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String getGroupIdList(int startRow, int pageSize) {
        return "SELECT group_id FROM config_info WHERE tenant_id ='' GROUP BY group_id OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String findAllConfigKey(int startRow, int pageSize) {
        return " SELECT data_id,group_id,app_name FROM  ( SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY ) g, config_info t  WHERE g.id = t.id ";
    }

    @Override
    public String findAllConfigInfoBaseFetchRows(int startRow, int pageSize) {
        return "SELECT t.id,data_id,group_id,content,md5  FROM ( SELECT id FROM config_info ORDER BY id OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY )   g, config_info t WHERE g.id = t.id ";
    }

    @Override
    public String findAllConfigInfoFragment(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,type FROM config_info WHERE id > ? ORDER BY id ASC OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String findChangeConfig() {
        return "SELECT data_id, group_id, tenant_id, app_name, content, gmt_modified FROM config_info WHERE gmt_modified > = ? AND gmt_modified <= ?";
    }

    @Override
    public String findChangeConfigCountRows(Map<String, String> params, Timestamp startTime, Timestamp endTime) {
        String tenant = params.get(TENANT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            where = where + " AND tenant_id = ? ";
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
        }
        return "SELECT count(*) FROM config_info WHERE " + where;
    }

    @Override
    public String findChangeConfigFetchRows(Map<String, String> params, Timestamp startTime, Timestamp endTime, int startRow, int pageSize, long lastMaxId) {
        String tenant = params.get(TENANT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            where = where + " AND tenant_id = ? ";
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE " + where + " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String listGroupKeyMd5ByPageFetchRows(int startRow, int pageSize) {
        return " SELECT t.id,data_id,group_id,tenant_id,app_name,type,md5,gmt_modified FROM ( SELECT id FROM config_info ORDER BY id OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY ) g, config_info t WHERE g.id = t.id";
    }

    @Override
    public String findAllConfigInfo4Export(List<Long> ids, Map<String, String> params) {
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,c_schema,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        if (!CollectionUtils.isEmpty(ids)) {
            where.append(" id IN (");
            for (int i = 0; i < ids.size(); ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append('?');
            }
            where.append(") ");
        } else {
            where.append(" tenant_id = ? ");
            if (!StringUtils.isEmpty((String)params.get(DATA_ID))) {
                where.append(" AND data_id LIKE ? ");
            }
            if (StringUtils.isNotEmpty((String)params.get(GROUP))) {
                where.append(" AND group_id = ? ");
            }
            if (StringUtils.isNotEmpty((String)params.get(APP_NAME))) {
                where.append(" AND app_name = ? ");
            }
        }
        return sql + where;
    }

    @Override
    public String findConfigInfoBaseLikeCountRows(Map<String, String> params) {
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='' ";
        if (!StringUtils.isBlank((CharSequence)params.get(DATA_ID))) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(GROUP))) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(CONTENT))) {
            where = where + " AND content LIKE ? ";
        }
        return "SELECT count(*) FROM config_info WHERE " + where;
    }

    @Override
    public String findConfigInfoBaseLikeFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='' ";
        if (!StringUtils.isBlank((CharSequence)params.get(DATA_ID))) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(GROUP))) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(CONTENT))) {
            where = where + " AND content LIKE ? ";
        }
        return "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE " + where + " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String findConfigInfo4PageCountRows(Map<String, String> params) {
        String appName = params.get(APP_NAME);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String sqlCount = "SELECT count(*) FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
        }
        return "SELECT count(*) FROM config_info" + where;
    }

    @Override
    public String findConfigInfo4PageFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String appName = params.get(APP_NAME);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,type FROM config_info" + where + " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String findConfigInfoBaseByGroupFetchRows(int startRow, int pageSize) {
        return "SELECT id,data_id,group_id,content FROM config_info WHERE group_id=? AND tenant_id=? OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String findConfigInfoLike4PageCountRows(Map<String, String> params) {
        String appName = params.get(APP_NAME);
        String content = params.get(CONTENT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String sqlCountRows = "SELECT count(*) FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT count(*) FROM config_info" + where;
    }

    @Override
    public String findConfigInfoLike4PageFetchRows(Map<String, String> params, int startRow, int pageSize) {
        String appName = params.get(APP_NAME);
        String content = params.get(CONTENT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info" + where + " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
    }

    @Override
    public String findAllConfigInfoFetchRows(int startRow, int pageSize) {
        return " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM ( SELECT id FROM config_info  WHERE tenant_id LIKE ? ORDER BY id OFFSET ? ROWS FETCH NEXT ? ROWS ONLY ) g, config_info t  WHERE g.id = t.id ";
    }

    @Override
    public String findConfigInfosByIds(int idSize) {
        StringBuilder sql = new StringBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content,md5 FROM config_info WHERE ");
        sql.append("id IN (");
        for (int i = 0; i < idSize; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    public String removeConfigInfoByIdsAtomic(int size) {
        StringBuilder sql = new StringBuilder("DELETE FROM config_info WHERE ");
        sql.append("id IN (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    public String updateConfigInfoAtomicCas() {
        return "UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?, app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? OR md5 IS NULL OR md5='')";
    }

    @Override
    public String getTableName() {
        return "config_info";
    }

    @Override
    public String getDataSource() {
        return "derby";
    }
}

