/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mtc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class MtContextThreadLocal<T>
extends InheritableThreadLocal<T> {
    static ThreadLocal<Map<MtContextThreadLocal<?>, ?>> holder = new ThreadLocal<Map<MtContextThreadLocal<?>, ?>>(){

        @Override
        protected Map<MtContextThreadLocal<?>, ?> initialValue() {
            return new WeakHashMap();
        }
    };

    protected T copy(T parentValue) {
        return parentValue;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public final T get() {
        Object value = super.get();
        if (null != value) {
            this.addMtContextThreadLocal();
        }
        return value;
    }

    @Override
    public final void set(T value) {
        super.set(value);
        if (null == value) {
            this.removeMtContextThreadLocal();
        } else {
            this.addMtContextThreadLocal();
        }
    }

    @Override
    public final void remove() {
        this.removeMtContextThreadLocal();
        super.remove();
    }

    private void superRemove() {
        super.remove();
    }

    T copyMtContextValue() {
        return this.copy(this.get());
    }

    void addMtContextThreadLocal() {
        if (!holder.get().containsKey(this)) {
            holder.get().put(this, null);
        }
    }

    void removeMtContextThreadLocal() {
        holder.get().remove(this);
    }

    static Map<MtContextThreadLocal<?>, Object> copy() {
        HashMap copy = new HashMap();
        for (MtContextThreadLocal<?> threadLocal : holder.get().keySet()) {
            copy.put(threadLocal, threadLocal.copyMtContextValue());
        }
        return copy;
    }

    static Map<MtContextThreadLocal<?>, Object> backupAndSet(Map<MtContextThreadLocal<?>, Object> copied) {
        MtContextThreadLocal<?> threadLocal;
        HashMap backup = new HashMap();
        Iterator<Map.Entry<MtContextThreadLocal<?>, ?>> iterator = holder.get().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MtContextThreadLocal<?>, ?> next = iterator.next();
            threadLocal = next.getKey();
            backup.put(threadLocal, threadLocal.get());
            if (copied.containsKey(threadLocal)) continue;
            iterator.remove();
            super.superRemove();
        }
        for (Map.Entry<MtContextThreadLocal<?>, Object> entry : copied.entrySet()) {
            threadLocal = entry.getKey();
            threadLocal.set(entry.getValue());
        }
        MtContextThreadLocal.doExecuteCallback(true);
        return backup;
    }

    static void restore(Map<MtContextThreadLocal<?>, Object> backup) {
        MtContextThreadLocal<?> threadLocal;
        MtContextThreadLocal.doExecuteCallback(false);
        Iterator<Map.Entry<MtContextThreadLocal<?>, ?>> iterator = holder.get().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MtContextThreadLocal<?>, ?> next = iterator.next();
            threadLocal = next.getKey();
            if (backup.containsKey(threadLocal)) continue;
            iterator.remove();
            super.superRemove();
        }
        for (Map.Entry<MtContextThreadLocal<?>, Object> entry : backup.entrySet()) {
            threadLocal = entry.getKey();
            threadLocal.set(entry.getValue());
        }
    }

    private static void doExecuteCallback(boolean isBefore) {
        for (Map.Entry<MtContextThreadLocal<?>, ?> entry : holder.get().entrySet()) {
            MtContextThreadLocal<?> threadLocal = entry.getKey();
            try {
                if (isBefore) {
                    threadLocal.beforeExecute();
                    continue;
                }
                threadLocal.afterExecute();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

