/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mtc;

import com.alibaba.mtc.MtContextThreadLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class MtContextRunnable
implements Runnable {
    private final AtomicReference<Map<MtContextThreadLocal<?>, Object>> copiedRef = new AtomicReference(MtContextThreadLocal.copy());
    private final Runnable runnable;
    private final boolean releaseMtContextAfterRun;

    private MtContextRunnable(Runnable runnable, boolean releaseMtContextAfterRun) {
        this.runnable = runnable;
        this.releaseMtContextAfterRun = releaseMtContextAfterRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<MtContextThreadLocal<?>, Object> copied = this.copiedRef.get();
        if (copied == null || this.releaseMtContextAfterRun && !this.copiedRef.compareAndSet(copied, null)) {
            throw new IllegalStateException("MtContext is released!");
        }
        Map<MtContextThreadLocal<?>, Object> backup = MtContextThreadLocal.backupAndSet(copied);
        try {
            this.runnable.run();
        }
        finally {
            MtContextThreadLocal.restore(backup);
        }
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public static MtContextRunnable get(Runnable runnable) {
        return MtContextRunnable.get(runnable, false, false);
    }

    public static MtContextRunnable get(Runnable runnable, boolean releaseMtContextAfterRun) {
        return MtContextRunnable.get(runnable, releaseMtContextAfterRun, false);
    }

    public static MtContextRunnable get(Runnable runnable, boolean releaseMtContextAfterRun, boolean idempotent) {
        if (null == runnable) {
            return null;
        }
        if (runnable instanceof MtContextRunnable) {
            if (idempotent) {
                return (MtContextRunnable)runnable;
            }
            throw new IllegalStateException("Already MtContextRunnable!");
        }
        return new MtContextRunnable(runnable, releaseMtContextAfterRun);
    }

    public static List<MtContextRunnable> gets(Collection<? extends Runnable> tasks) {
        return MtContextRunnable.gets(tasks, false, false);
    }

    public static List<MtContextRunnable> gets(Collection<? extends Runnable> tasks, boolean releaseMtContextAfterRun) {
        if (null == tasks) {
            return null;
        }
        ArrayList<MtContextRunnable> copy = new ArrayList<MtContextRunnable>();
        for (Runnable runnable : tasks) {
            copy.add(MtContextRunnable.get(runnable, releaseMtContextAfterRun, false));
        }
        return copy;
    }

    public static List<MtContextRunnable> gets(Collection<? extends Runnable> tasks, boolean releaseMtContextAfterRun, boolean idempotent) {
        if (null == tasks) {
            return null;
        }
        ArrayList<MtContextRunnable> copy = new ArrayList<MtContextRunnable>();
        for (Runnable runnable : tasks) {
            copy.add(MtContextRunnable.get(runnable, releaseMtContextAfterRun, idempotent));
        }
        return copy;
    }
}

