/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mtc;

import com.alibaba.mtc.MtContextThreadLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public final class MtContextCallable<V>
implements Callable<V> {
    private final AtomicReference<Map<MtContextThreadLocal<?>, Object>> copiedRef = new AtomicReference(MtContextThreadLocal.copy());
    private final Callable<V> callable;
    private final boolean releaseMtContextAfterCall;

    private MtContextCallable(Callable<V> callable, boolean releaseMtContextAfterCall) {
        this.callable = callable;
        this.releaseMtContextAfterCall = releaseMtContextAfterCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        Map<MtContextThreadLocal<?>, Object> copied = this.copiedRef.get();
        if (copied == null || this.releaseMtContextAfterCall && !this.copiedRef.compareAndSet(copied, null)) {
            throw new IllegalStateException("MtContext is released!");
        }
        Map<MtContextThreadLocal<?>, Object> backup = MtContextThreadLocal.backupAndSet(copied);
        try {
            V v = this.callable.call();
            return v;
        }
        finally {
            MtContextThreadLocal.restore(backup);
        }
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public static <T> MtContextCallable<T> get(Callable<T> callable) {
        return MtContextCallable.get(callable, false);
    }

    public static <T> MtContextCallable<T> get(Callable<T> callable, boolean releaseMtContextAfterCall) {
        return MtContextCallable.get(callable, releaseMtContextAfterCall, false);
    }

    public static <T> MtContextCallable<T> get(Callable<T> callable, boolean releaseMtContextAfterCall, boolean idempotent) {
        if (null == callable) {
            return null;
        }
        if (callable instanceof MtContextCallable) {
            if (idempotent) {
                return (MtContextCallable)callable;
            }
            throw new IllegalStateException("Already MtContextCallable!");
        }
        return new MtContextCallable<T>(callable, releaseMtContextAfterCall);
    }

    public static <T> List<MtContextCallable<T>> gets(Collection<? extends Callable<T>> tasks) {
        return MtContextCallable.gets(tasks, false, false);
    }

    public static <T> List<MtContextCallable<T>> gets(Collection<? extends Callable<T>> tasks, boolean releaseMtContextAfterCall) {
        if (null == tasks) {
            return null;
        }
        ArrayList<MtContextCallable<T>> copy = new ArrayList<MtContextCallable<T>>();
        for (Callable<T> task : tasks) {
            copy.add(MtContextCallable.get(task, releaseMtContextAfterCall, false));
        }
        return copy;
    }

    public static <T> List<MtContextCallable<T>> gets(Collection<? extends Callable<T>> tasks, boolean releaseMtContextAfterCall, boolean idempotent) {
        if (null == tasks) {
            return null;
        }
        ArrayList<MtContextCallable<T>> copy = new ArrayList<MtContextCallable<T>>();
        for (Callable<T> task : tasks) {
            copy.add(MtContextCallable.get(task, releaseMtContextAfterCall, idempotent));
        }
        return copy;
    }
}

