/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.exec;

import com.alibaba.fescar.rm.datasource.ParametersHolder;
import com.alibaba.fescar.rm.datasource.StatementProxy;
import com.alibaba.fescar.rm.datasource.exec.AbstractDMLBaseExecutor;
import com.alibaba.fescar.rm.datasource.exec.StatementCallback;
import com.alibaba.fescar.rm.datasource.sql.SQLRecognizer;
import com.alibaba.fescar.rm.datasource.sql.SQLUpdateRecognizer;
import com.alibaba.fescar.rm.datasource.sql.struct.Field;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMeta;
import com.alibaba.fescar.rm.datasource.sql.struct.TableRecords;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UpdateExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    public UpdateExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableRecords beforeImage() throws SQLException {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        TableMeta tmeta = this.getTableMeta();
        List<String> updateColumns = recognizer.getUpdateColumns();
        StringBuffer selectSQLAppender = new StringBuffer("SELECT ");
        if (!tmeta.containsPK(updateColumns)) {
            selectSQLAppender.append(this.getColumnNameInSQL(tmeta.getPkName()) + ", ");
        }
        for (int i = 0; i < updateColumns.size(); ++i) {
            selectSQLAppender.append(updateColumns.get(i));
            if (i >= updateColumns.size() - 1) continue;
            selectSQLAppender.append(", ");
        }
        String whereCondition = null;
        ArrayList<Object> paramAppender = new ArrayList<Object>();
        whereCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getWhereCondition((ParametersHolder)((Object)this.statementProxy), paramAppender) : recognizer.getWhereCondition();
        selectSQLAppender.append(" FROM " + this.getFromTableInSQL());
        if (StringUtils.isNotBlank((String)whereCondition)) {
            selectSQLAppender.append(" WHERE " + whereCondition);
        }
        selectSQLAppender.append(" FOR UPDATE");
        String selectSQL = selectSQLAppender.toString();
        TableRecords beforeImage = null;
        PreparedStatement ps = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            if (paramAppender.isEmpty()) {
                st = this.statementProxy.getConnection().createStatement();
                rs = st.executeQuery(selectSQL);
            } else {
                ps = this.statementProxy.getConnection().prepareStatement(selectSQL);
                for (int i = 0; i < paramAppender.size(); ++i) {
                    ps.setObject(i + 1, paramAppender.get(i));
                }
                rs = ps.executeQuery();
            }
            beforeImage = TableRecords.buildRecords(tmeta, rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return beforeImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        TableMeta tmeta = this.getTableMeta();
        if (beforeImage == null || beforeImage.size() == 0) {
            return TableRecords.empty(this.getTableMeta());
        }
        List<String> updateColumns = recognizer.getUpdateColumns();
        StringBuffer selectSQLAppender = new StringBuffer("SELECT ");
        if (!tmeta.containsPK(updateColumns)) {
            selectSQLAppender.append(this.getColumnNameInSQL(tmeta.getPkName()) + ", ");
        }
        for (int i = 0; i < updateColumns.size(); ++i) {
            selectSQLAppender.append(updateColumns.get(i));
            if (i >= updateColumns.size() - 1) continue;
            selectSQLAppender.append(", ");
        }
        List<Field> pkRows = beforeImage.pkRows();
        selectSQLAppender.append(" FROM " + this.getFromTableInSQL() + " WHERE " + this.buildWhereConditionByPKs(pkRows) + " FOR UPDATE");
        String selectSQL = selectSQLAppender.toString();
        TableRecords afterImage = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.statementProxy.getConnection().prepareStatement(selectSQL);
            int index = 0;
            for (Field pkField : pkRows) {
                pst.setObject(++index, pkField.getValue(), pkField.getType());
            }
            rs = pst.executeQuery();
            afterImage = TableRecords.buildRecords(tmeta, rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
        }
        return afterImage;
    }
}

