/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.websocket.sockjs;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import java.io.InputStream;
import org.springframework.web.socket.sockjs.frame.AbstractSockJsMessageCodec;

public class FastjsonSockJsMessageCodec
extends AbstractSockJsMessageCodec {
    private FastJsonConfig config = new FastJsonConfig();

    public FastJsonConfig getFastJsonConfig() {
        return this.config;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.config = fastJsonConfig;
    }

    public String[] decode(String content) {
        return (String[])JSON.parseObject((String)content, String[].class, (JSONReader.Feature[])this.config.getReaderFeatures());
    }

    public String[] decodeInputStream(InputStream content) {
        return (String[])JSON.parseObject((InputStream)content, String[].class, (JSONReader.Feature[])this.config.getReaderFeatures());
    }

    protected char[] applyJsonQuoting(String content) {
        return content.toCharArray();
    }

    public String encode(String ... messages) {
        JSONWriter jsonWriter = JSONWriter.of((JSONWriter.Feature[])this.config.getWriterFeatures());
        if (jsonWriter.isUTF8()) {
            jsonWriter.writeRaw(new byte[]{97});
        } else {
            jsonWriter.writeRaw(new char[]{'a'});
        }
        jsonWriter.startArray();
        for (int i = 0; i < messages.length; ++i) {
            if (i != 0) {
                jsonWriter.writeComma();
            }
            String message = messages[i];
            jsonWriter.writeString(message);
        }
        jsonWriter.endArray();
        return jsonWriter.toString();
    }
}

