/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.odps;

import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.support.odps.JSONWritable;
import com.alibaba.fastjson2.util.IOUtils;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.udf.UDF;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class JSONExtract
extends UDF {
    private static JSONWritable[] cache = new JSONWritable[512];
    static final byte[] BYTES_TRUE;
    static final byte[] BYTES_FALSE;
    private final JSONPath path;
    private JSONWritable text = new JSONWritable();
    private ExtractValueConsumer valueConsumer = new ExtractValueConsumer();

    public JSONExtract(String path) {
        this.path = JSONPath.of((String)path);
    }

    public Writable eval(Text input) {
        JSONReader jsonReader = JSONReader.of((byte[])input.getBytes(), (int)0, (int)input.getLength(), (Charset)StandardCharsets.UTF_8);
        this.path.extract(jsonReader, (ValueConsumer)this.valueConsumer);
        if (this.text == null) {
            return NullWritable.get();
        }
        return this.text;
    }

    static {
        for (int i = -1; i < 511; ++i) {
            int size = i < 0 ? IOUtils.stringSize((int)(-i)) + 1 : IOUtils.stringSize((int)i);
            byte[] bytes = new byte[size + 2];
            bytes[0] = 34;
            bytes[size + 1] = 34;
            IOUtils.getChars((int)i, (int)(size + 1), (byte[])bytes);
            JSONExtract.cache[i + 1] = new JSONWritable(bytes);
        }
        BYTES_TRUE = new byte[]{34, 116, 114, 117, 101, 34};
        BYTES_FALSE = new byte[]{34, 102, 97, 108, 115, 101, 34};
    }

    class ExtractValueConsumer
    implements ValueConsumer {
        ExtractValueConsumer() {
        }

        public void accept(byte[] bytes, int off, int len) {
            ((JSONExtract)JSONExtract.this).text.bytes = bytes;
            ((JSONExtract)JSONExtract.this).text.off = off;
            ((JSONExtract)JSONExtract.this).text.length = len;
        }

        public void acceptNull() {
            JSONExtract.this.text = null;
        }

        public void accept(boolean val) {
            JSONExtract.this.text.set(val ? BYTES_TRUE : BYTES_FALSE);
        }

        public void accept(int val) {
            if (val >= -1 && val < 511) {
                JSONExtract.this.text = cache[val + 1];
                return;
            }
            int size = val < 0 ? IOUtils.stringSize((int)(-val)) + 1 : IOUtils.stringSize((int)val);
            JSONExtract.this.text.setCapacity(size + 2, false);
            byte[] bytes = ((JSONExtract)JSONExtract.this).text.bytes;
            bytes[0] = 34;
            bytes[size + 1] = 34;
            IOUtils.getChars((int)val, (int)(size + 1), (byte[])bytes);
            ((JSONExtract)JSONExtract.this).text.length = size + 2;
        }

        public void accept(long val) {
            int size = val < 0L ? IOUtils.stringSize((long)(-val)) + 1 : IOUtils.stringSize((long)val);
            byte[] bytes = new byte[size + 2];
            bytes[0] = 34;
            bytes[size + 1] = 34;
            IOUtils.getChars((long)val, (int)(size + 1), (byte[])bytes);
            JSONExtract.this.text.set(bytes);
        }

        public void accept(Number val) {
            if (val instanceof Integer) {
                this.accept(val.intValue());
                return;
            }
            if (val instanceof Long) {
                this.accept(val.longValue());
                return;
            }
            String str = val.toString();
            int len = str.length() + 2;
            byte[] bytes = new byte[len + 2];
            bytes[0] = 34;
            bytes[len + 1] = 34;
            str.getBytes(0, len, bytes, 1);
            JSONExtract.this.text.set(bytes);
        }

        public void accept(String val) {
            JSONExtract.this.text.set(val);
        }

        public void accept(Map object) {
            throw new UnsupportedOperationException();
        }

        public void accept(List array) {
            throw new UnsupportedOperationException();
        }
    }
}

