/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.processor;

import com.alibaba.fastjson2.annotation.JSONCompiled;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.internal.processor.AttributeInfo;
import com.alibaba.fastjson2.internal.processor.CodeGenUtils;
import com.alibaba.fastjson2.internal.processor.StructInfo;
import com.alibaba.fastjson2.util.BeanUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class Analysis {
    final ProcessingEnvironment processingEnv;
    final Elements elements;
    private final Types types;
    final TypeElement jsonCompiledElement;
    final TypeElement jsonTypeElement;
    public final DeclaredType jsonCompiledDeclaredType;
    public final DeclaredType jsonTypeDeclaredType;
    final Map<String, StructInfo> structs = new LinkedHashMap<String, StructInfo>();

    public Analysis(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.jsonCompiledElement = this.elements.getTypeElement(JSONCompiled.class.getName());
        this.jsonCompiledDeclaredType = this.types.getDeclaredType(this.jsonCompiledElement, new TypeMirror[0]);
        this.jsonTypeElement = this.elements.getTypeElement(JSONType.class.getName());
        this.jsonTypeDeclaredType = this.types.getDeclaredType(this.jsonTypeElement, new TypeMirror[0]);
    }

    public void processAnnotation(DeclaredType currentAnnotationType, Set<? extends Element> targets) {
        Stack<String> path = new Stack<String>();
        for (Element element : targets) {
            Element classElement;
            ExecutableElement factory = null;
            ExecutableElement builder = null;
            if (element instanceof TypeElement) {
                classElement = element;
            } else if (element instanceof ExecutableElement && element.getKind() == ElementKind.METHOD) {
                ExecutableElement ee = (ExecutableElement)element;
                Element returnClass = this.types.asElement(ee.getReturnType());
                Element enclosing = ee.getEnclosingElement();
                if (!element.getModifiers().contains((Object)Modifier.STATIC) && !this.types.isSameType(ee.getReturnType(), enclosing.asType()) && returnClass.toString().equals(enclosing.getEnclosingElement().toString())) {
                    builder = ee;
                }
                factory = ee;
                classElement = returnClass;
            } else {
                classElement = element.getEnclosingElement();
            }
            this.findStructs(classElement, currentAnnotationType, currentAnnotationType + " requires accessible public constructor", path, factory, builder);
        }
    }

    private void findStructs(Element el, DeclaredType discoveredBy, String errorMessage, Stack<String> path, ExecutableElement factory, ExecutableElement builder) {
        if (!(el instanceof TypeElement)) {
            return;
        }
        String typeName = el.toString();
        TypeElement element = (TypeElement)el;
        String name = "struct" + this.structs.size();
        String binaryName = this.elements.getBinaryName(element).toString();
        StructInfo info = new StructInfo(this.types, element, this.jsonCompiledDeclaredType, this.jsonTypeDeclaredType, name, binaryName);
        this.structs.put(typeName, info);
    }

    static int getModifiers(Set<Modifier> modifiers) {
        int modifierValue = 0;
        for (Modifier modifier : modifiers) {
            switch (modifier) {
                case PUBLIC: {
                    modifierValue |= 1;
                    break;
                }
                case PRIVATE: {
                    modifierValue |= 2;
                    break;
                }
                case FINAL: {
                    modifierValue |= 0x10;
                    break;
                }
            }
        }
        return modifierValue;
    }

    public Map<String, StructInfo> analyze() {
        this.findRelatedReferences();
        return this.structs;
    }

    private void findRelatedReferences() {
        for (Map.Entry<String, StructInfo> entry : this.structs.entrySet()) {
            StructInfo info = entry.getValue();
            for (TypeElement inheritance : this.getTypeHierarchy(info.element)) {
                for (VariableElement field : ElementFilter.fieldsIn(inheritance.getEnclosedElements())) {
                    Set<Modifier> modifiers = field.getModifiers();
                    if (modifiers.contains((Object)Modifier.TRANSIENT) || modifiers.contains((Object)Modifier.STATIC)) continue;
                    FieldInfo fieldInfo = new FieldInfo();
                    String name = field.getSimpleName().toString();
                    JSONField[] annotations = (JSONField[])field.getAnnotationsByType(JSONField.class);
                    for (JSONField annotation : annotations) {
                        CodeGenUtils.getFieldInfo(fieldInfo, annotation, false);
                    }
                    if (fieldInfo.fieldName != null) {
                        name = fieldInfo.fieldName;
                    }
                    info.getAttributeByField(name, field);
                }
                for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                    List<? extends VariableElement> parameters = method.getParameters();
                    int parameterCount = parameters.size();
                    String methodName = method.getSimpleName().toString();
                    if (parameterCount > 2) continue;
                    boolean ignored = false;
                    if (parameterCount == 0) {
                        switch (methodName) {
                            case "hashCode": {
                                ignored = true;
                                break;
                            }
                        }
                    } else if (parameterCount == 1) {
                        ignored = "equals".equals(methodName);
                    }
                    if (ignored) continue;
                    ExecutableElement getter = null;
                    ExecutableElement setter = null;
                    TypeMirror type = null;
                    String name = null;
                    if (parameters.size() == 0 && (methodName.startsWith("get") || methodName.startsWith("is"))) {
                        name = BeanUtils.getterName((String)methodName, null);
                        getter = method;
                        type = method.getReturnType();
                    } else {
                        if (!methodName.startsWith("set") || method.getParameters().size() != 1) continue;
                        name = BeanUtils.setterName((String)methodName, null);
                        setter = method;
                        type = method.getParameters().get(0).asType();
                    }
                    AttributeInfo attributeInfo = info.getAttributeByMethod(name, type, getter, setter);
                }
            }
        }
    }

    private List<TypeElement> getTypeHierarchy(TypeElement element) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        this.getAllTypes(element, result, new HashSet<TypeElement>());
        return result;
    }

    private void getAllTypes(TypeElement element, List<TypeElement> result, Set<TypeElement> processed) {
        if (!processed.add(element) || element.getQualifiedName().contentEquals("java.lang.Object")) {
            return;
        }
        result.add(element);
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            Element current = this.types.asElement(typeMirror);
            if (!(current instanceof TypeElement)) continue;
            this.getAllTypes((TypeElement)current, result, processed);
        }
    }
}

