/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.processor;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.internal.codegen.Block;
import com.alibaba.fastjson2.internal.codegen.ClassWriter;
import com.alibaba.fastjson2.internal.codegen.MethodWriter;
import com.alibaba.fastjson2.internal.codegen.Opcodes;
import com.alibaba.fastjson2.internal.processor.Analysis;
import com.alibaba.fastjson2.internal.processor.AttributeInfo;
import com.alibaba.fastjson2.internal.processor.CodeGenUtils;
import com.alibaba.fastjson2.internal.processor.StructInfo;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.util.BeanUtils;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.alibaba.fastjson2.annotation.JSONCompiled", "com.alibaba.fastjson2.annotation.JSONBuilder", "com.alibaba.fastjson2.annotation.JSONCreator", "com.alibaba.fastjson2.annotation.JSONField", "com.alibaba.fastjson2.annotation.JSONType"})
public class JSONCompiledAnnotationProcessor
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        Analysis analysis = new Analysis(this.processingEnv);
        Set<? extends Element> compiledJsons = roundEnv.getElementsAnnotatedWith(analysis.jsonCompiledElement);
        if (!compiledJsons.isEmpty()) {
            analysis.processAnnotation(analysis.compiledJsonType, compiledJsons);
        }
        Map<String, StructInfo> structs = analysis.analyze();
        HashMap<String, StructInfo> generatedFiles = new HashMap<String, StructInfo>();
        ArrayList<TypeElement> originatingElements = new ArrayList<TypeElement>();
        for (Map.Entry<String, StructInfo> entry : structs.entrySet()) {
            String typeName = entry.getKey();
            StructInfo info = entry.getValue();
            String classNamePath = JSONCompiledAnnotationProcessor.findConverterName(info);
            try {
                JavaFileObject converterFile = this.processingEnv.getFiler().createSourceFile(classNamePath, info.element);
                try {
                    Writer writer = converterFile.openWriter();
                    try {
                        JSONCompiledAnnotationProcessor.buildCode(writer, this.processingEnv, entry.getKey(), info, structs);
                        generatedFiles.put(classNamePath, info);
                        originatingElements.add(info.element);
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving compiled json serialization file " + classNamePath);
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed creating compiled json serialization file " + classNamePath);
            }
        }
        return false;
    }

    static String findConverterName(StructInfo structInfo) {
        int dotIndex = structInfo.binaryName.lastIndexOf(46);
        String className = structInfo.binaryName.substring(dotIndex + 1);
        if (dotIndex == -1) {
            return className + "_FASTJOSNReader";
        }
        String packageName = structInfo.binaryName.substring(0, dotIndex);
        return packageName + '.' + className + "_FASTJOSNReader";
    }

    private static void buildCode(Writer code, ProcessingEnvironment environment, String className, StructInfo si, Map<String, StructInfo> structs) throws IOException {
        boolean generatedFields;
        String generateFullClassName = JSONCompiledAnnotationProcessor.findConverterName(si);
        int dotIndex = generateFullClassName.lastIndexOf(46);
        String generateClassName = generateFullClassName.substring(dotIndex + 1);
        String packageName = null;
        if (dotIndex != -1) {
            packageName = generateFullClassName.substring(0, dotIndex);
        }
        List<AttributeInfo> fields = si.getReaderAttributes();
        Class supperClass = CodeGenUtils.getSupperClass(fields.size());
        ClassWriter cw = new ClassWriter(packageName, generateClassName, supperClass, new Class[0]);
        boolean bl = generatedFields = fields.size() < 128;
        if (generatedFields) {
            JSONCompiledAnnotationProcessor.genFields(fields, cw, supperClass);
        }
        MethodWriter mw = cw.method(1, "<init>", Void.TYPE, new Class[0], new String[0]);
        Opcodes.Op[] fieldReaders = new Opcodes.Op[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Opcodes.Op fieldReader;
            boolean fieldTypeIsClass;
            AttributeInfo attr = fields.get(i);
            String fieldType = attr.type.toString();
            boolean bl2 = fieldTypeIsClass = fieldType.indexOf(60) == -1;
            if (attr.setMethod != null) {
                String methodName = attr.setMethod.getSimpleName().toString();
                fieldReader = Opcodes.invoke(Opcodes.getStatic(ObjectReaderCreator.class, "INSTANCE"), "createFieldReader", Opcodes.ldc(attr.name), Opcodes.invokeStatic(BeanUtils.class, "getSetter", Opcodes.getStatic(className, "class"), Opcodes.ldc(methodName)));
            } else if (attr.field != null) {
                fieldReaders[i] = fieldReader = Opcodes.invoke(Opcodes.getStatic(ObjectReaderCreator.class, "INSTANCE"), "createFieldReader", Opcodes.ldc(attr.name), Opcodes.invokeStatic(BeanUtils.class, "getDeclaredField", Opcodes.getStatic(className, "class"), Opcodes.ldc(attr.field.getSimpleName().toString())));
            } else {
                throw new IOException("TODO");
            }
            fieldReaders[i] = fieldReader;
        }
        mw.invoke(Opcodes.SUPER, "<init>", Opcodes.getStatic(className, "class"), Opcodes.ldc(si.typeKey), Opcodes.ldc(null), Opcodes.ldc(si.readerFeatures), Opcodes.methodRef(className, "new"), Opcodes.ldc(null), Opcodes.allocateArray(FieldReader.class, null, fieldReaders));
        JSONCompiledAnnotationProcessor.genInitFields(fields.size(), generatedFields, "fieldReaders", mw, supperClass);
        mw = cw.method(1, "createInstance", Object.class, new Class[]{Long.TYPE}, new String[]{"features"});
        mw.ret(Opcodes.allocate(className, new Opcodes.Op[0]));
        JSONCompiledAnnotationProcessor.genMethodReadObject(className, si, fields, cw, false);
        code.write(cw.toString());
    }

    static void genInitFields(int fieldReaderArray, boolean generatedFields, String fieldReaders, MethodWriter mw, Class objectReaderSuper) {
        if (objectReaderSuper != ObjectReaderAdapter.class || !generatedFields) {
            return;
        }
        for (int i = 0; i < fieldReaderArray; ++i) {
            mw.putField(CodeGenUtils.fieldReader(i), Opcodes.arrayGet(Opcodes.var(fieldReaders), Opcodes.ldc(i)));
        }
    }

    static void genFields(List<AttributeInfo> fields, ClassWriter cw, Class objectReaderSuper) {
        int i;
        int fieldCount = fields.size();
        if (objectReaderSuper == ObjectReaderAdapter.class) {
            for (i = 0; i < fieldCount; ++i) {
                cw.field(1, CodeGenUtils.fieldReader(i), FieldReader.class);
            }
            for (i = 0; i < fieldCount; ++i) {
                cw.field(1, CodeGenUtils.fieldObjectReader(i), ObjectReader.class);
            }
        }
        for (i = 0; i < fields.size(); ++i) {
            AttributeInfo field = fields.get(i);
            String fieldType = field.type.toString();
            if (!fieldType.startsWith("java.util.List<")) continue;
            cw.field(1, CodeGenUtils.fieldItemObjectReader(i), ObjectReader.class);
        }
    }

    public static void genMethodReadObject(String className, StructInfo si, List<AttributeInfo> fields, ClassWriter cw, boolean jsonb) {
        MethodWriter mw = cw.method(1, "readObject", Object.class, new Class[]{JSONReader.class, Type.class, Object.class, Long.TYPE}, new String[]{"jsonReader", "fieldType", "fieldName", "features"});
        Opcodes.OpName jsonReader = Opcodes.var("jsonReader");
        Opcodes.OpName features = Opcodes.var("features");
        Opcodes.OpName fieldType = Opcodes.var("fieldType");
        Opcodes.OpName fieldName = Opcodes.var("fieldName");
        Opcodes.OpName object = Opcodes.var("object");
        mw.ifStmt(Opcodes.invoke(jsonReader, "nextIfNull", new Opcodes.Op[0])).ret(Opcodes.ldc(null));
        mw.newLine();
        mw.stmt(Opcodes.invoke(jsonReader, "nextIfObjectStart", new Opcodes.Op[0]));
        mw.declare(className, object, Opcodes.allocate(className, new Opcodes.Op[0]));
        String forLabel = "_for";
        mw.label(forLabel);
        Block.ForStmt forStmt = mw.forStmt(null, null, null, null);
        forStmt.ifStmt(Opcodes.invoke(jsonReader, "nextIfObjectEnd", new Opcodes.Op[0])).breakStmt();
        Opcodes.OpName hashCode64 = Opcodes.var("hashCode64");
        forStmt.declare(Long.TYPE, hashCode64, Opcodes.invoke(jsonReader, "readFieldNameHashCode", new Opcodes.Op[0]));
        forStmt.ifStmt(Opcodes.eq(hashCode64, Opcodes.ldc(0))).breakStmt(null);
        if (fields.size() <= 6) {
            for (int i = 0; i < fields.size(); ++i) {
                AttributeInfo field = fields.get(i);
                long fieldNameHash = field.nameHashCode;
                Block.IfStmt ifStmt = forStmt.ifStmt(Opcodes.eq(hashCode64, Opcodes.ldc(fieldNameHash)));
                JSONCompiledAnnotationProcessor.genReadFieldValue(ifStmt, i, si, field, jsonReader, object, forLabel, jsonb);
                ifStmt.continueStmt();
            }
        } else {
            TreeMap<Integer, List> map = new TreeMap<Integer, List>();
            TreeMap<Long, AttributeInfo> mapping = new TreeMap<Long, AttributeInfo>();
            TreeMap<Long, Integer> mappingIndex = new TreeMap<Long, Integer>();
            for (int i = 0; i < fields.size(); ++i) {
                AttributeInfo field = fields.get(i);
                long fieldNameHash = field.nameHashCode;
                int hashCode32 = (int)(fieldNameHash ^ fieldNameHash >>> 32);
                List hashCode64List = map.computeIfAbsent(hashCode32, k -> new ArrayList());
                hashCode64List.add(fieldNameHash);
                mapping.put(fieldNameHash, field);
                mappingIndex.put(fieldNameHash, i);
            }
            int[] hashCode32Keys = new int[map.size()];
            int off = 0;
            for (Integer key : map.keySet()) {
                hashCode32Keys[off++] = key;
            }
            Arrays.sort(hashCode32Keys);
            Opcodes.OpName hashCode32 = Opcodes.var("hashCode32");
            forStmt.declare(Integer.TYPE, hashCode32, Opcodes.cast(Opcodes.eor(hashCode64, Opcodes.urs(hashCode64, Opcodes.ldc(32))), Integer.TYPE));
            Block.SwitchStmt switchStmt = forStmt.switchStmt(hashCode32, hashCode32Keys);
            for (int i = 0; i < switchStmt.labels(); ++i) {
                Block label = switchStmt.lable(i);
                List hashCode64Array = (List)map.get(switchStmt.labelKey(i));
                if (hashCode64Array.size() == 1 && (Long)hashCode64Array.get(0) == (long)hashCode32Keys[i]) {
                    Long fieldNameHash = (Long)hashCode64Array.get(0);
                    int index = (Integer)mappingIndex.get(fieldNameHash);
                    AttributeInfo field = (AttributeInfo)mapping.get(fieldNameHash);
                    JSONCompiledAnnotationProcessor.genReadFieldValue(label, index, si, field, jsonReader, object, forLabel, jsonb);
                    label.continueStmt(forLabel);
                    continue;
                }
                for (int j = 0; j < hashCode64Array.size(); ++j) {
                    Long fieldNameHash = (Long)hashCode64Array.get(j);
                    int index = (Integer)mappingIndex.get(fieldNameHash);
                    AttributeInfo field = (AttributeInfo)mapping.get(fieldNameHash);
                    Block.IfStmt ifStmt = label.ifStmt(Opcodes.eq(hashCode64, Opcodes.ldc(fieldNameHash)));
                    JSONCompiledAnnotationProcessor.genReadFieldValue(ifStmt, index, si, field, jsonReader, object, forLabel, jsonb);
                    ifStmt.continueStmt(forLabel);
                }
                label.breakStmt();
            }
        }
        forStmt.stmt(Opcodes.invoke(null, "processExtra", jsonReader, object));
        mw.ret(object);
    }

    static void genReadFieldValue(Block mw, int i, StructInfo info, AttributeInfo field, Opcodes.Op jsonReader, Opcodes.Op object, String continueLabel, boolean jsonb) {
        Opcodes.Op value;
        String type;
        switch (type = field.type.toString()) {
            case "boolean": {
                value = Opcodes.invoke(jsonReader, "readBoolValue", new Opcodes.Op[0]);
                break;
            }
            case "byte": {
                value = Opcodes.cast(Opcodes.invoke(jsonReader, "readInt32Value", new Opcodes.Op[0]), Byte.TYPE);
                break;
            }
            case "short": {
                value = Opcodes.cast(Opcodes.invoke(jsonReader, "readInt32Value", new Opcodes.Op[0]), Short.TYPE);
                break;
            }
            case "int": {
                value = Opcodes.invoke(jsonReader, "readInt32Value", new Opcodes.Op[0]);
                break;
            }
            case "long": {
                value = Opcodes.invoke(jsonReader, "readInt64Value", new Opcodes.Op[0]);
                break;
            }
            case "float": {
                value = Opcodes.invoke(jsonReader, "readFloatValue", new Opcodes.Op[0]);
                break;
            }
            case "double": {
                value = Opcodes.invoke(jsonReader, "readDoubleValue", new Opcodes.Op[0]);
                break;
            }
            case "char": {
                value = Opcodes.invoke(jsonReader, "readCharValue", new Opcodes.Op[0]);
                break;
            }
            case "int[]": {
                value = Opcodes.invoke(jsonReader, "readInt32ValueArray", new Opcodes.Op[0]);
                break;
            }
            case "long[]": {
                value = Opcodes.invoke(jsonReader, "readInt64ValueArray", new Opcodes.Op[0]);
                break;
            }
            case "java.lang.String": {
                value = Opcodes.invoke(jsonReader, "readString", new Opcodes.Op[0]);
                break;
            }
            case "java.lang.Integer": {
                value = Opcodes.invoke(jsonReader, "readInt32", new Opcodes.Op[0]);
                break;
            }
            case "java.lang.Long": {
                value = Opcodes.invoke(jsonReader, "readInt64", new Opcodes.Op[0]);
                break;
            }
            case "java.lang.Float": {
                value = Opcodes.invoke(jsonReader, "readFloat", new Opcodes.Op[0]);
                break;
            }
            case "java.lang.readDouble": {
                value = Opcodes.invoke(jsonReader, "readDouble", new Opcodes.Op[0]);
                break;
            }
            case "java.math.BigDecimal": {
                value = Opcodes.invoke(jsonReader, "readBigDecimal", new Opcodes.Op[0]);
                break;
            }
            case "java.math.BigInteger": {
                value = Opcodes.invoke(jsonReader, "readBigInteger", new Opcodes.Op[0]);
                break;
            }
            case "java.util.UUID": {
                value = Opcodes.invoke(jsonReader, "readUUID", new Opcodes.Op[0]);
                break;
            }
            case "java.lang.String[]": {
                value = Opcodes.invoke(jsonReader, "readStringArray", new Opcodes.Op[0]);
                break;
            }
            case "java.time.LocalDate": {
                value = Opcodes.invoke(jsonReader, "readLocalDate", new Opcodes.Op[0]);
                break;
            }
            case "java.time.OffsetDateTime": {
                value = Opcodes.invoke(jsonReader, "readOffsetDateTime", new Opcodes.Op[0]);
                break;
            }
            default: {
                if (info.referenceDetect) {
                    Block.IfStmt isRef = mw.ifStmt(Opcodes.invoke(jsonReader, "isReference", new Opcodes.Op[0]));
                    Opcodes.OpName ref = Opcodes.var("ref");
                    isRef.declare(String.class, ref, Opcodes.invoke(jsonReader, "readReference", new Opcodes.Op[0]));
                    isRef.stmt(Opcodes.invoke(Opcodes.var(CodeGenUtils.fieldReader(i)), "addResolveTask", jsonReader, object, ref));
                    isRef.continueStmt(continueLabel);
                }
                Opcodes.OpName fieldValue = Opcodes.var(field.name);
                mw.declare(type, fieldValue);
                boolean list = type.startsWith("java.util.List<");
                if (list) {
                    boolean itemTypeIsClass;
                    String itemType = type.substring(15, type.length() - 1);
                    boolean bl = itemTypeIsClass = itemType.indexOf(60) == -1;
                    if (itemTypeIsClass) {
                        Block.IfStmt nextIfNull = mw.ifStmt(Opcodes.invoke(jsonReader, "nextIfNull", new Opcodes.Op[0]));
                        nextIfNull.stmt(Opcodes.assign(fieldValue, Opcodes.ldc(null)));
                        Block nextIfNullElse = nextIfNull.elseStmt();
                        nextIfNullElse.stmt(Opcodes.assign(fieldValue, Opcodes.allocate(ArrayList.class, new Opcodes.Op[0])));
                        boolean stringItemClass = "java.lang.String".equals(itemType);
                        Opcodes.OpName itemReader = Opcodes.var(CodeGenUtils.fieldItemObjectReader(i));
                        if (!stringItemClass) {
                            nextIfNullElse.ifNull(itemReader).stmt(Opcodes.assign(itemReader, Opcodes.invoke(Opcodes.getField(Opcodes.THIS, CodeGenUtils.fieldReader(i)), "getItemObjectReader", jsonReader)));
                        }
                        Block.IfStmt nextIfMatch = nextIfNullElse.ifStmt(Opcodes.invoke(jsonReader, "nextIfArrayStart", new Opcodes.Op[0]));
                        Block.WhileStmt whileStmt = nextIfMatch.whileStmtStmt(Opcodes.not(Opcodes.invoke(jsonReader, "nextIfArrayEnd", new Opcodes.Op[0])));
                        Opcodes.Op item = stringItemClass ? Opcodes.invoke(jsonReader, "readString", new Opcodes.Op[0]) : Opcodes.cast(Opcodes.invoke(itemReader, "readObject", jsonReader, Opcodes.ldc(null), Opcodes.ldc(null), Opcodes.ldc(0L)), itemType);
                        whileStmt.stmt(Opcodes.invoke(fieldValue, "add", item));
                        value = fieldValue;
                        break;
                    }
                }
                mw.ifNull(Opcodes.var(CodeGenUtils.fieldObjectReader(i))).putField(CodeGenUtils.fieldObjectReader(i), Opcodes.invoke(Opcodes.var(CodeGenUtils.fieldReader(i)), "getObjectReader", jsonReader));
                mw.stmt(Opcodes.assign(fieldValue, Opcodes.cast(Opcodes.invoke(Opcodes.var(CodeGenUtils.fieldObjectReader(i)), jsonb ? "readJSONBObject" : "readObject", jsonReader, Opcodes.getField(Opcodes.var(CodeGenUtils.fieldReader(i)), "fieldType"), Opcodes.ldc(field.name), Opcodes.ldc(field.readerFeatures)), type)));
                value = fieldValue;
            }
        }
        if (field.setMethod != null) {
            mw.invoke(object, field.setMethod.getSimpleName().toString(), value);
        } else if (field.field != null) {
            mw.putField(object, field.field.getSimpleName().toString(), value);
        } else {
            throw new JSONException("TODO");
        }
    }
}

