/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.simdjson;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.benchmark.simdjson.ParseBenchmark;
import com.alibaba.fastjson2.benchmark.simdjson.SimdJsonPaddingUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.simdjson.SimdJsonParser;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class SchemaBasedParseAndSelectBenchmark {
    private final SimdJsonParser simdJsonParser;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private byte[] buffer;
    private byte[] bufferPadded;

    public SchemaBasedParseAndSelectBenchmark() {
        SimdJsonParser p = null;
        try {
            p = new SimdJsonParser();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.simdJsonParser = p;
    }

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        try (InputStream is = ParseBenchmark.class.getResourceAsStream("/data/simd-json/twitter.json");){
            this.buffer = is.readAllBytes();
            this.bufferPadded = SimdJsonPaddingUtil.padded(this.buffer);
        }
    }

    @Benchmark
    public int countUniqueUsersWithDefaultProfile_simdjson() {
        HashSet<String> defaultUsers = new HashSet<String>();
        SimdJsonTwitter twitter = (SimdJsonTwitter)this.simdJsonParser.parse(this.buffer, this.buffer.length, SimdJsonTwitter.class);
        for (SimdJsonStatus status : twitter.statuses()) {
            SimdJsonUser user = status.user();
            if (!user.default_profile()) continue;
            defaultUsers.add(user.screen_name());
        }
        return defaultUsers.size();
    }

    @Benchmark
    public int countUniqueUsersWithDefaultProfile_simdjsonPadded() {
        HashSet<String> defaultUsers = new HashSet<String>();
        SimdJsonTwitter twitter = (SimdJsonTwitter)this.simdJsonParser.parse(this.bufferPadded, this.buffer.length, SimdJsonTwitter.class);
        for (SimdJsonStatus status : twitter.statuses()) {
            SimdJsonUser user = status.user();
            if (!user.default_profile()) continue;
            defaultUsers.add(user.screen_name());
        }
        return defaultUsers.size();
    }

    @Benchmark
    public int countUniqueUsersWithDefaultProfile_jackson() throws IOException {
        HashSet<String> defaultUsers = new HashSet<String>();
        SimdJsonTwitter twitter = (SimdJsonTwitter)this.objectMapper.readValue(this.buffer, SimdJsonTwitter.class);
        for (SimdJsonStatus status : twitter.statuses()) {
            SimdJsonUser user = status.user();
            if (!user.default_profile()) continue;
            defaultUsers.add(user.screen_name());
        }
        return defaultUsers.size();
    }

    @Benchmark
    public int countUniqueUsersWithDefaultProfile_fastjson() {
        HashSet<String> defaultUsers = new HashSet<String>();
        SimdJsonTwitter twitter = (SimdJsonTwitter)JSON.parseObject((byte[])this.buffer, SimdJsonTwitter.class);
        for (SimdJsonStatus status : twitter.statuses()) {
            SimdJsonUser user = status.user();
            if (!user.default_profile()) continue;
            defaultUsers.add(user.screen_name());
        }
        return defaultUsers.size();
    }

    @Benchmark
    public int countUniqueUsersWithDefaultProfile_wast() {
        HashSet<String> defaultUsers = new HashSet<String>();
        SimdJsonTwitter twitter = (SimdJsonTwitter)io.github.wycst.wast.json.JSON.parseObject((byte[])this.buffer, SimdJsonTwitter.class);
        for (SimdJsonStatus status : twitter.statuses()) {
            SimdJsonUser user = status.user();
            if (!user.default_profile()) continue;
            defaultUsers.add(user.screen_name());
        }
        return defaultUsers.size();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(SchemaBasedParseAndSelectBenchmark.class.getName()).jvmArgsAppend(new String[]{"--add-opens=java.base/java.time=ALL-UNNAMED", "--add-modules=jdk.incubator.vector"}).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    public record SimdJsonTwitter(List<SimdJsonStatus> statuses) {
    }

    public record SimdJsonStatus(SimdJsonUser user) {
    }

    public record SimdJsonUser(boolean default_profile, String screen_name) {
    }
}

